/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfEnv;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvSingleton;
import java.util.LinkedHashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class CfSingleSignOnEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered,
ApplicationListener<ApplicationEvent> {
    private static final String PIVOTAL_SSO_LABEL = "p-identity";
    private static final String PROPERTY_SOURCE_NAME = "cfSingleSignOnEnvironmentPostProcessor";
    private static DeferredLog DEFERRED_LOG = new DeferredLog();
    private static int invocationCount;
    private int order = -2147483639;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.increaseInvocationCount();
        if (CloudPlatform.CLOUD_FOUNDRY.isActive((Environment)environment)) {
            CfService cfService;
            CfEnv cfEnv = CfEnvSingleton.getCfEnvInstance();
            try {
                cfService = cfEnv.findServiceByLabel(new String[]{PIVOTAL_SSO_LABEL});
            }
            catch (Exception e) {
                if (invocationCount == 1) {
                    DEFERRED_LOG.debug((Object)("Skipping execution of CfSingleSignOnEnvironmentPostProcessor.  " + e.getMessage()));
                }
                return;
            }
            if (cfService != null) {
                CfCredentials cfCredentials = cfService.getCredentials();
                String clientId = cfCredentials.getString(new String[]{"client_id"});
                String clientSecret = cfCredentials.getString(new String[]{"client_secret"});
                String authDomain = cfCredentials.getString(new String[]{"auth_domain"});
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                properties.put("security.oauth2.client.clientId", clientId);
                properties.put("security.oauth2.client.clientSecret", clientSecret);
                properties.put("security.oauth2.client.accessTokenUri", authDomain + "/oauth/token");
                properties.put("security.oauth2.client.userAuthorizationUri", authDomain + "/oauth/authorize");
                properties.put("ssoServiceUrl", authDomain);
                properties.put("security.oauth2.resource.userInfoUri", authDomain + "/userinfo");
                properties.put("security.oauth2.resource.tokenInfoUri", authDomain + "/check_token");
                properties.put("security.oauth2.resource.jwk.key-set-uri", authDomain + "/token_keys");
                MutablePropertySources propertySources = environment.getPropertySources();
                if (propertySources.contains("commandLineArgs")) {
                    propertySources.addAfter("commandLineArgs", (PropertySource)new MapPropertySource(PROPERTY_SOURCE_NAME, properties));
                } else {
                    propertySources.addFirst((PropertySource)new MapPropertySource(PROPERTY_SOURCE_NAME, properties));
                }
                if (invocationCount == 1) {
                    DEFERRED_LOG.info((Object)("Setting security.oauth2.client properties from bound service [" + cfService.getName() + "]"));
                }
            }
        } else if (invocationCount == 1) {
            DEFERRED_LOG.debug((Object)"Not setting security.oauth2.client properties, not in Cloud Foundry Environment");
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            DEFERRED_LOG.switchTo(CfSingleSignOnEnvironmentPostProcessor.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseInvocationCount() {
        CfSingleSignOnEnvironmentPostProcessor cfSingleSignOnEnvironmentPostProcessor = this;
        synchronized (cfSingleSignOnEnvironmentPostProcessor) {
            ++invocationCount;
        }
    }
}

