/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.jdbc.CfJdbcEnv;
import io.pivotal.cfenv.jdbc.CfJdbcService;
import java.util.LinkedHashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class CfDataSourceEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered,
ApplicationListener<ApplicationEvent> {
    private static DeferredLog DEFERRED_LOG = new DeferredLog();
    private static int invocationCount;
    private int order = -2147483639;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.increaseInvocationCount();
        if (CloudPlatform.CLOUD_FOUNDRY.isActive((Environment)environment)) {
            CfJdbcService cfJdbcService;
            CfJdbcEnv cfJdbcEnv = new CfJdbcEnv();
            try {
                cfJdbcService = cfJdbcEnv.findJdbcService();
            }
            catch (Exception e) {
                if (invocationCount == 1) {
                    DEFERRED_LOG.debug((Object)("Skipping execution of CfDataSourceEnvironmentPostProcessor. " + e.getMessage()));
                }
                return;
            }
            if (cfJdbcService != null) {
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                properties.put("spring.datasource.url", cfJdbcService.getUrl());
                properties.put("spring.datasource.username", cfJdbcService.getUsername());
                properties.put("spring.datasource.password", cfJdbcService.getPassword());
                properties.put("spring.datasource.driver-class-name", cfJdbcService.getDriverClassName());
                MutablePropertySources propertySources = environment.getPropertySources();
                if (propertySources.contains("commandLineArgs")) {
                    propertySources.addAfter("commandLineArgs", (PropertySource)new MapPropertySource("cfenvjdbc", properties));
                } else {
                    propertySources.addFirst((PropertySource)new MapPropertySource("cfenvjdbc", properties));
                }
                if (invocationCount == 1) {
                    DEFERRED_LOG.info((Object)("Setting spring.datasource properties from bound service [" + cfJdbcService.getName() + "]"));
                }
            }
        } else {
            DEFERRED_LOG.debug((Object)"Not setting spring.datasource.url, not in Cloud Foundry Environment");
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            DEFERRED_LOG.switchTo(CfDataSourceEnvironmentPostProcessor.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseInvocationCount() {
        CfDataSourceEnvironmentPostProcessor cfDataSourceEnvironmentPostProcessor = this;
        synchronized (cfDataSourceEnvironmentPostProcessor) {
            ++invocationCount;
        }
    }
}

