/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.clients;

import io.pinecone.clients.Pinecone;
import io.pinecone.configs.PineconeConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.openapitools.inference.client.ApiClient;
import org.openapitools.inference.client.ApiException;
import org.openapitools.inference.client.api.InferenceApi;
import org.openapitools.inference.client.model.EmbedRequest;
import org.openapitools.inference.client.model.EmbedRequestInputsInner;
import org.openapitools.inference.client.model.EmbeddingsList;
import org.openapitools.inference.client.model.ModelInfo;
import org.openapitools.inference.client.model.ModelInfoList;
import org.openapitools.inference.client.model.RerankRequest;
import org.openapitools.inference.client.model.RerankResult;

public class Inference {
    private final InferenceApi inferenceApi;

    public Inference(PineconeConfig config) {
        OkHttpClient customOkHttpClient = config.getCustomOkHttpClient();
        ApiClient apiClient = customOkHttpClient != null ? new ApiClient(customOkHttpClient) : new ApiClient(Pinecone.buildOkHttpClient(config.getProxyConfig()));
        apiClient.setApiKey(config.getApiKey());
        apiClient.setUserAgent(config.getUserAgent());
        apiClient.addDefaultHeader("X-Pinecone-Api-Version", "2025-04");
        this.inferenceApi = new InferenceApi(apiClient);
    }

    public EmbeddingsList embed(String model, Map<String, Object> parameters, List<String> inputs) throws ApiException {
        EmbedRequest embedRequest = new EmbedRequest().model(model).parameters(parameters).inputs(this.convertToEmbedInputs(inputs));
        return this.inferenceApi.embed(embedRequest);
    }

    public RerankResult rerank(String model, String query, List<Map<String, Object>> documents) throws ApiException {
        return this.rerank(model, query, documents, Arrays.asList("text"), documents.size(), true, new HashMap<String, Object>());
    }

    public RerankResult rerank(String model, String query, List<Map<String, Object>> documents, List<String> rankFields, int topN, boolean returnDocuments, Map<String, Object> parameters) throws ApiException {
        RerankRequest rerankRequest = new RerankRequest();
        rerankRequest.model(model).query(query).documents(documents).rankFields(rankFields).topN(topN).returnDocuments(returnDocuments).parameters(parameters);
        return this.inferenceApi.rerank(rerankRequest);
    }

    public ModelInfoList listModels() throws ApiException {
        return this.inferenceApi.listModels(null, null);
    }

    public ModelInfoList listModels(String type) throws ApiException {
        return this.inferenceApi.listModels(type, null);
    }

    public ModelInfoList listModels(String type, String vectorType) throws ApiException {
        return this.inferenceApi.listModels(type, vectorType);
    }

    public ModelInfo describeModel(String modelName) throws ApiException {
        return this.inferenceApi.getModel(modelName);
    }

    private List<EmbedRequestInputsInner> convertToEmbedInputs(List<String> inputs) {
        return inputs.stream().map(input -> new EmbedRequestInputsInner().text((String)input)).collect(Collectors.toList());
    }
}

