/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.db_data.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.db_data.client.JSON;
import org.openapitools.db_data.client.model.QueryVector;
import org.openapitools.db_data.client.model.SparseValues;

public class QueryRequest {
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_TOP_K = "topK";
    @SerializedName(value="topK")
    private Long topK;
    public static final String SERIALIZED_NAME_FILTER = "filter";
    @SerializedName(value="filter")
    private Object filter;
    public static final String SERIALIZED_NAME_INCLUDE_VALUES = "includeValues";
    @SerializedName(value="includeValues")
    private Boolean includeValues = false;
    public static final String SERIALIZED_NAME_INCLUDE_METADATA = "includeMetadata";
    @SerializedName(value="includeMetadata")
    private Boolean includeMetadata = false;
    public static final String SERIALIZED_NAME_QUERIES = "queries";
    @Deprecated
    @SerializedName(value="queries")
    private List<QueryVector> queries;
    public static final String SERIALIZED_NAME_VECTOR = "vector";
    @SerializedName(value="vector")
    private List<Float> vector;
    public static final String SERIALIZED_NAME_SPARSE_VECTOR = "sparseVector";
    @SerializedName(value="sparseVector")
    private SparseValues sparseVector;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public QueryRequest namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public QueryRequest topK(Long topK) {
        this.topK = topK;
        return this;
    }

    @Nonnull
    public Long getTopK() {
        return this.topK;
    }

    public void setTopK(Long topK) {
        this.topK = topK;
    }

    public QueryRequest filter(Object filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        this.filter = filter;
    }

    public QueryRequest includeValues(Boolean includeValues) {
        this.includeValues = includeValues;
        return this;
    }

    @Nullable
    public Boolean getIncludeValues() {
        return this.includeValues;
    }

    public void setIncludeValues(Boolean includeValues) {
        this.includeValues = includeValues;
    }

    public QueryRequest includeMetadata(Boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
        return this;
    }

    @Nullable
    public Boolean getIncludeMetadata() {
        return this.includeMetadata;
    }

    public void setIncludeMetadata(Boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    @Deprecated
    public QueryRequest queries(List<QueryVector> queries) {
        this.queries = queries;
        return this;
    }

    public QueryRequest addQueriesItem(QueryVector queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<QueryVector>();
        }
        this.queries.add(queriesItem);
        return this;
    }

    @Deprecated
    @Nullable
    public List<QueryVector> getQueries() {
        return this.queries;
    }

    @Deprecated
    public void setQueries(List<QueryVector> queries) {
        this.queries = queries;
    }

    public QueryRequest vector(List<Float> vector) {
        this.vector = vector;
        return this;
    }

    public QueryRequest addVectorItem(Float vectorItem) {
        if (this.vector == null) {
            this.vector = new ArrayList<Float>();
        }
        this.vector.add(vectorItem);
        return this;
    }

    @Nullable
    public List<Float> getVector() {
        return this.vector;
    }

    public void setVector(List<Float> vector) {
        this.vector = vector;
    }

    public QueryRequest sparseVector(SparseValues sparseVector) {
        this.sparseVector = sparseVector;
        return this;
    }

    @Nullable
    public SparseValues getSparseVector() {
        return this.sparseVector;
    }

    public void setSparseVector(SparseValues sparseVector) {
        this.sparseVector = sparseVector;
    }

    public QueryRequest id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public QueryRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRequest queryRequest = (QueryRequest)o;
        return Objects.equals(this.namespace, queryRequest.namespace) && Objects.equals(this.topK, queryRequest.topK) && Objects.equals(this.filter, queryRequest.filter) && Objects.equals(this.includeValues, queryRequest.includeValues) && Objects.equals(this.includeMetadata, queryRequest.includeMetadata) && Objects.equals(this.queries, queryRequest.queries) && Objects.equals(this.vector, queryRequest.vector) && Objects.equals(this.sparseVector, queryRequest.sparseVector) && Objects.equals(this.id, queryRequest.id) && Objects.equals(this.additionalProperties, queryRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.topK, this.filter, this.includeValues, this.includeMetadata, this.queries, this.vector, this.sparseVector, this.id, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryRequest {\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    topK: ").append(this.toIndentedString(this.topK)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    includeValues: ").append(this.toIndentedString(this.includeValues)).append("\n");
        sb.append("    includeMetadata: ").append(this.toIndentedString(this.includeMetadata)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    vector: ").append(this.toIndentedString(this.vector)).append("\n");
        sb.append("    sparseVector: ").append(this.toIndentedString(this.sparseVector)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayqueries;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in QueryRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QUERIES) != null && !jsonObj.get(SERIALIZED_NAME_QUERIES).isJsonNull() && (jsonArrayqueries = jsonObj.getAsJsonArray(SERIALIZED_NAME_QUERIES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_QUERIES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `queries` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QUERIES).toString()));
            }
            for (int i = 0; i < jsonArrayqueries.size(); ++i) {
                QueryVector.validateJsonElement(jsonArrayqueries.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VECTOR) != null && !jsonObj.get(SERIALIZED_NAME_VECTOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VECTOR).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `vector` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VECTOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SPARSE_VECTOR) != null && !jsonObj.get(SERIALIZED_NAME_SPARSE_VECTOR).isJsonNull()) {
            SparseValues.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SPARSE_VECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
    }

    public static QueryRequest fromJson(String jsonString) throws IOException {
        return (QueryRequest)JSON.getGson().fromJson(jsonString, QueryRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_TOP_K);
        openapiFields.add(SERIALIZED_NAME_FILTER);
        openapiFields.add(SERIALIZED_NAME_INCLUDE_VALUES);
        openapiFields.add(SERIALIZED_NAME_INCLUDE_METADATA);
        openapiFields.add(SERIALIZED_NAME_QUERIES);
        openapiFields.add(SERIALIZED_NAME_VECTOR);
        openapiFields.add(SERIALIZED_NAME_SPARSE_VECTOR);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TOP_K);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!QueryRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(QueryRequest.class));
            return new TypeAdapter<QueryRequest>(){

                public void write(JsonWriter out, QueryRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public QueryRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    QueryRequest.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    QueryRequest instance = (QueryRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

