/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.tracewriter;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
final class TraceEvent
implements Cloneable {
    static final TraceEvent EVENT = new TraceEvent();
    @SerializedName(value="ph")
    private String phase;
    @SerializedName(value="name")
    private String name;
    @Nullable
    @SerializedName(value="cat")
    private String categories;
    @Nullable
    @SerializedName(value="ts")
    private Double traceClockMicros;
    @Nullable
    @SerializedName(value="pid")
    private Long pid;
    @SerializedName(value="tid")
    @Nullable
    private Long tid;
    @Nullable
    @SerializedName(value="id")
    private Long id;
    @Nullable
    @SerializedName(value="args")
    private Map<String, ?> args = null;
    @Nullable
    @SerializedName(value="cname")
    private String colorName = null;
    private transient int argCalls;

    private TraceEvent() {
    }

    TraceEvent name(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        TraceEvent other = this.clone();
        other.name = name;
        return other;
    }

    TraceEvent categories(String ... categories) {
        if (categories == null) {
            throw new NullPointerException("categories");
        }
        return this.categories(Arrays.asList(categories));
    }

    TraceEvent categories(List<String> categories) {
        if (categories == null) {
            throw new NullPointerException("categories");
        }
        TraceEvent other = this.clone();
        if (!categories.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            ListIterator<String> it = categories.listIterator();
            sb.append(it.next());
            while (it.hasNext()) {
                String next = it.next();
                if (next == null) {
                    throw new NullPointerException("next null at " + (it.nextIndex() - 1));
                }
                sb.append(',').append(next);
            }
            other.categories = sb.toString();
        } else {
            other.categories = null;
        }
        return other;
    }

    strictfp TraceEvent traceClockNanos(long traceClockNanos) {
        TraceEvent other = this.clone();
        other.traceClockMicros = (double)traceClockNanos / 1000.0;
        return other;
    }

    TraceEvent phase(String phase) {
        if (phase == null) {
            throw new NullPointerException("phase");
        }
        TraceEvent other = this.clone();
        other.phase = phase;
        return other;
    }

    TraceEvent tid(long tid) {
        TraceEvent other = this.clone();
        other.tid = tid;
        return other;
    }

    TraceEvent pid(long pid) {
        TraceEvent other = this.clone();
        other.pid = pid;
        return other;
    }

    TraceEvent id(long id) {
        TraceEvent other = this.clone();
        other.id = id;
        return other;
    }

    TraceEvent args(Map<String, ?> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        LinkedHashMap newArgs = new LinkedHashMap(args.size());
        for (Map.Entry<String, ?> arg : args.entrySet()) {
            if (arg.getKey() == null) {
                throw new NullPointerException("key");
            }
            if (arg.getValue() == null) {
                throw new NullPointerException("value");
            }
            newArgs.put(arg.getKey(), arg.getValue());
        }
        TraceEvent other = this.clone();
        other.args = !newArgs.isEmpty() ? Collections.unmodifiableMap(newArgs) : null;
        return other;
    }

    TraceEvent arg(String argKey, Object argValue) {
        if (argKey == null) {
            throw new NullPointerException("argKey");
        }
        if (argValue == null) {
            throw new NullPointerException("argValue");
        }
        TraceEvent other = this.clone();
        if (this.args == null) {
            other.args = Collections.singletonMap(argKey, argValue);
        } else {
            LinkedHashMap newArgs = new LinkedHashMap(this.args);
            newArgs.put(argKey, argValue);
            other.args = Collections.unmodifiableMap(newArgs);
        }
        return other;
    }

    int getArgsSize() {
        return this.argCalls;
    }

    void incrementArgsSize() {
        ++this.argCalls;
    }

    protected TraceEvent clone() {
        try {
            return (TraceEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

