/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.tracewriter;

import io.perfmark.impl.Mark;
import io.perfmark.impl.MarkList;
import io.perfmark.impl.Marker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class MarkListWalker {
    MarkListWalker() {
    }

    final void walk(List<? extends MarkList> markLists, long nowNanoTime) {
        Map<Long, List<MarkList>> generationToMarkLists = MarkListWalker.groupMarkListsByGeneration(markLists);
        for (Map.Entry<Long, List<MarkList>> entry : generationToMarkLists.entrySet()) {
            this.enterGeneration(entry.getKey());
            for (MarkList markList : entry.getValue()) {
                this.enterMarkList(markList.getThreadName(), markList.getThreadId(), markList.getMarkListId());
                ArrayDeque fakeStarts = new ArrayDeque();
                ArrayDeque fakeEnds = new ArrayDeque();
                Set<Mark> unmatchedPairMarks = Collections.newSetFromMap(new IdentityHashMap());
                MarkListWalker.createFakes(fakeStarts, fakeEnds, unmatchedPairMarks, markList.getMarks(), nowNanoTime);
                for (Mark mark : fakeStarts) {
                    this.onTaskStart(mark, true, false);
                }
                for (Mark mark : markList.getMarks()) {
                    this.onRealMark(mark, unmatchedPairMarks);
                }
                for (Mark mark : fakeEnds) {
                    this.onTaskEnd(mark, false, true);
                }
                this.exitMarkList();
            }
            this.exitGeneration();
        }
    }

    protected void enterGeneration(long generation) {
    }

    protected void exitGeneration() {
    }

    protected void enterMarkList(String threadName, long threadId, long markListId) {
    }

    protected void exitMarkList() {
    }

    private void onRealMark(Mark mark, Collection<Mark> unmatchedPairMarks) {
        switch (mark.getOperation()) {
            case TASK_START: 
            case TASK_START_T: 
            case TASK_START_M: 
            case TASK_START_TM: {
                this.onTaskStart(mark, false, unmatchedPairMarks.contains(mark));
                return;
            }
            case TASK_END: 
            case TASK_END_T: 
            case TASK_END_M: 
            case TASK_END_TM: {
                this.onTaskEnd(mark, unmatchedPairMarks.contains(mark), false);
                return;
            }
            case EVENT: 
            case EVENT_T: 
            case EVENT_M: 
            case EVENT_TM: {
                this.onEvent(mark);
                return;
            }
            case LINK: 
            case LINK_M: {
                this.onLink(mark);
                return;
            }
        }
        throw new AssertionError();
    }

    protected void onTaskStart(Mark mark, boolean unmatchedStart, boolean unmatchedEnd) {
    }

    protected void onTaskEnd(Mark mark, boolean unmatchedStart, boolean unmatchedEnd) {
    }

    protected void onLink(Mark mark) {
    }

    protected void onEvent(Mark mark) {
    }

    private static Map<Long, List<MarkList>> groupMarkListsByGeneration(List<? extends MarkList> markLists) {
        TreeMap<Long, List<MarkList>> generationToMarkLists = new TreeMap<Long, List<MarkList>>();
        for (MarkList markList : markLists) {
            List marks = markList.getMarks();
            if (marks.isEmpty()) continue;
            TreeMap<Long, ArrayList<Mark>> generationToMarks = new TreeMap<Long, ArrayList<Mark>>();
            for (Mark mark : marks) {
                ArrayList<Mark> groupedMarks = (ArrayList<Mark>)generationToMarks.get(mark.getGeneration());
                if (groupedMarks == null) {
                    groupedMarks = new ArrayList<Mark>();
                    generationToMarks.put(mark.getGeneration(), groupedMarks);
                }
                groupedMarks.add(mark);
            }
            for (Map.Entry entry : generationToMarks.entrySet()) {
                ArrayList<MarkList> groupedMarkLists = (ArrayList<MarkList>)generationToMarkLists.get(entry.getKey());
                if (groupedMarkLists == null) {
                    groupedMarkLists = new ArrayList<MarkList>();
                    generationToMarkLists.put((Long)entry.getKey(), (List<MarkList>)groupedMarkLists);
                }
                groupedMarkLists.add(markList.toBuilder().setMarks((List)entry.getValue()).build());
            }
        }
        return generationToMarkLists;
    }

    private static void createFakes(Deque<? super Mark> fakeStarts, Deque<? super Mark> fakeEnds, Set<? super Mark> unmatchedPairMarks, List<Mark> marks, long nowNanoTime) {
        ArrayDeque<Mark> unmatchedMarks = new ArrayDeque<Mark>();
        long[] nanoTimeBounds = new long[]{nowNanoTime, nowNanoTime};
        block5: for (Mark mark : marks) {
            MarkListWalker.setNanoTimeBounds(nanoTimeBounds, mark);
            switch (mark.getOperation()) {
                case TASK_START: 
                case TASK_START_T: 
                case TASK_START_M: 
                case TASK_START_TM: {
                    unmatchedMarks.addLast(mark);
                    continue block5;
                }
                case TASK_END: 
                case TASK_END_T: 
                case TASK_END_M: 
                case TASK_END_TM: {
                    if (!unmatchedMarks.isEmpty()) {
                        unmatchedMarks.removeLast();
                        continue block5;
                    }
                    fakeStarts.addFirst((Mark)MarkListWalker.createFakeStart(mark, nanoTimeBounds[0]));
                    unmatchedPairMarks.add((Mark)mark);
                    continue block5;
                }
                case EVENT: 
                case EVENT_T: 
                case EVENT_M: 
                case EVENT_TM: 
                case LINK: 
                case LINK_M: {
                    continue block5;
                }
            }
            throw new AssertionError();
        }
        for (Mark unmatchedMark : unmatchedMarks) {
            fakeEnds.addFirst((Mark)MarkListWalker.createFakeEnd(unmatchedMark, nanoTimeBounds[1]));
            unmatchedPairMarks.add((Mark)unmatchedMark);
        }
        unmatchedMarks.clear();
    }

    private static void setNanoTimeBounds(long[] nanoTimeBounds, Mark mark) {
        switch (mark.getOperation()) {
            case TASK_START: 
            case TASK_START_T: 
            case TASK_START_M: 
            case TASK_START_TM: 
            case TASK_END: 
            case TASK_END_T: 
            case TASK_END_M: 
            case TASK_END_TM: 
            case EVENT: 
            case EVENT_T: 
            case EVENT_M: 
            case EVENT_TM: {
                if (mark.getNanoTime() - nanoTimeBounds[0] < 0L) {
                    nanoTimeBounds[0] = mark.getNanoTime();
                }
                if (mark.getNanoTime() - nanoTimeBounds[1] > 0L) {
                    nanoTimeBounds[1] = mark.getNanoTime();
                }
                return;
            }
            case LINK: 
            case LINK_M: {
                return;
            }
        }
        throw new AssertionError();
    }

    private static Mark createFakeEnd(Mark start, long lastNanoTime) {
        Mark.Operation op;
        switch (start.getOperation()) {
            case TASK_START: {
                op = Mark.Operation.TASK_END;
                break;
            }
            case TASK_START_T: {
                op = Mark.Operation.TASK_END_T;
                break;
            }
            case TASK_START_M: {
                op = Mark.Operation.TASK_END_M;
                break;
            }
            case TASK_START_TM: {
                op = Mark.Operation.TASK_END_TM;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return Mark.create((String)String.valueOf(start.getTaskName()), (Marker)start.getMarker(), (String)start.getTagName(), (long)start.getTagId(), (long)lastNanoTime, (long)start.getGeneration(), (Mark.Operation)op);
    }

    private static Mark createFakeStart(Mark end, long firstNanoTime) {
        Mark.Operation op;
        switch (end.getOperation()) {
            case TASK_END: {
                op = Mark.Operation.TASK_START;
                break;
            }
            case TASK_END_T: {
                op = Mark.Operation.TASK_START_T;
                break;
            }
            case TASK_END_M: {
                op = Mark.Operation.TASK_START_M;
                break;
            }
            case TASK_END_TM: {
                op = Mark.Operation.TASK_START_TM;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return Mark.create((String)String.valueOf(end.getTaskName()), (Marker)end.getMarker(), (String)end.getTagName(), (long)end.getTagId(), (long)firstNanoTime, (long)end.getGeneration(), (Mark.Operation)op);
    }
}

