/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java6;

import io.perfmark.impl.Mark;
import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkList;
import io.perfmark.impl.MarkRecorderRef;
import io.perfmark.impl.Storage;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

final class SynchronizedMarkHolder
extends MarkHolder {
    private static final long GEN_MASK = 255L;
    private final MarkRecorderRef markRecorderRef;
    private final int maxEvents;
    private final long maxEventsMask;
    private long nIdx;
    private long sIdx;
    private final long[] nums;
    private final String[] strings;

    SynchronizedMarkHolder(int maxEvents, MarkRecorderRef markRecorderRef) {
        if ((maxEvents - 1 & maxEvents) != 0) {
            throw new IllegalArgumentException(maxEvents + " is not a power of two");
        }
        if (maxEvents <= 0) {
            throw new IllegalArgumentException(maxEvents + " is not positive");
        }
        this.maxEvents = maxEvents;
        this.maxEventsMask = (long)maxEvents - 1L;
        this.nums = new long[maxEvents];
        this.strings = new String[maxEvents];
        this.markRecorderRef = markRecorderRef;
    }

    void writeNnss(long genOp, long n0, long n1, String s0, String s1) {
        assert (Thread.holdsLock((Object)this));
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n1;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s1;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    void writeNss(long genOp, long n0, String s0, String s1) {
        assert (Thread.holdsLock((Object)this));
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s1;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    void writeNs(long genOp, long n0, String s0) {
        assert (Thread.holdsLock((Object)this));
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    void writeTs(long genOp, String s0) {
        assert (Thread.holdsLock((Object)this));
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = System.nanoTime();
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    void writeTss(long genOp, String s0, String s1) {
        assert (Thread.holdsLock((Object)this));
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = System.nanoTime();
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s1;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    void writeN(long genOp, long n0) {
        assert (Thread.holdsLock((Object)this));
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    void writeNns(long genOp, long n0, long n1, String s0) {
        assert (Thread.holdsLock((Object)this));
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = n1;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    void writeSs(long genOp, String s0, String s1) {
        assert (Thread.holdsLock((Object)this));
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s0;
        this.strings[(int)(this.sIdx++ & this.maxEventsMask)] = s1;
        this.nums[(int)(this.nIdx++ & this.maxEventsMask)] = genOp;
    }

    public synchronized void resetForThread() {
        if (this.markRecorderRef.threadInfo().isTerminated()) {
            Storage.unregisterMarkHolder((MarkHolder)this);
        }
        if (!this.markRecorderRef.threadInfo().isCurrentThread()) {
            return;
        }
        Arrays.fill(this.nums, 0L);
        Arrays.fill(this.strings, null);
        this.nIdx = 0L;
        this.sIdx = 0L;
    }

    public synchronized void resetForAll() {
        this.resetForThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MarkList> read() {
        long sIdx;
        long nIdx;
        long[] nums = new long[this.maxEvents];
        String[] strings = new String[this.maxEvents];
        SynchronizedMarkHolder synchronizedMarkHolder = this;
        synchronized (synchronizedMarkHolder) {
            System.arraycopy(this.nums, 0, nums, 0, this.maxEvents);
            System.arraycopy(this.strings, 0, strings, 0, this.maxEvents);
            nIdx = this.nIdx;
            sIdx = this.sIdx;
        }
        Long[] numsBoxed = new Long[nums.length];
        for (int i = 0; i < nums.length; ++i) {
            numsBoxed[i] = nums[i];
        }
        Kyoo<Long> numQ = new Kyoo<Long>(numsBoxed, nIdx, (int)Math.min(nIdx, (long)this.maxEvents));
        Kyoo<String> stringQ = new Kyoo<String>(strings, sIdx, (int)Math.min(sIdx, (long)this.maxEvents));
        ArrayDeque<Mark> marks = new ArrayDeque<Mark>(this.maxEvents);
        while (!numQ.isEmpty()) {
            long genOp = numQ.remove();
            long gen = genOp & 0xFFFFFFFFFFFFFF00L;
            Mark.Operation op = Mark.Operation.valueOf((int)((int)(genOp & 0xFFL)));
            if (op.getNumbers() > numQ.size() || op.getStrings() > stringQ.size()) break;
            switch (op) {
                case TASK_START_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.taskStart((long)gen, (long)n1, (String)s1));
                    break;
                }
                case TASK_START_N1S2: {
                    long n1 = numQ.remove();
                    String s2 = stringQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.taskStart((long)gen, (long)n1, (String)s1, (String)s2));
                    break;
                }
                case TASK_END_N1S0: {
                    long n1 = numQ.remove();
                    marks.addFirst(Mark.taskEnd((long)gen, (long)n1));
                    break;
                }
                case TASK_END_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.taskEnd((long)gen, (long)n1, (String)s1));
                    break;
                }
                case TASK_END_N1S2: {
                    long n1 = numQ.remove();
                    String s2 = stringQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.taskEnd((long)gen, (long)n1, (String)s1, (String)s2));
                    break;
                }
                case EVENT_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.event((long)gen, (long)n1, (String)s1));
                    break;
                }
                case EVENT_N1S2: {
                    long n1 = numQ.remove();
                    String s2 = stringQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.event((long)gen, (long)n1, (String)s1, (String)s2));
                    break;
                }
                case EVENT_N2S2: {
                    long n2 = numQ.remove();
                    String s2 = stringQ.remove();
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.event((long)gen, (long)n1, (String)s1, (String)s2, (long)n2));
                    break;
                }
                case EVENT_N2S3: {
                    throw new UnsupportedOperationException();
                }
                case LINK: {
                    long n1 = numQ.remove();
                    marks.addFirst(Mark.link((long)gen, (long)n1));
                    break;
                }
                case TAG_N0S1: {
                    throw new UnsupportedOperationException();
                }
                case TAG_N1S0: {
                    throw new UnsupportedOperationException();
                }
                case TAG_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.tag((long)gen, (String)s1, (long)n1));
                    break;
                }
                case TAG_KEYED_N0S2: {
                    String s2 = stringQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.keyedTag((long)gen, (String)s1, (String)s2));
                    break;
                }
                case TAG_KEYED_N1S1: {
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.keyedTag((long)gen, (String)s1, (long)n1));
                    break;
                }
                case TAG_KEYED_N2S1: {
                    long n2 = numQ.remove();
                    long n1 = numQ.remove();
                    String s1 = stringQ.remove();
                    marks.addFirst(Mark.keyedTag((long)gen, (String)s1, (long)n1, (long)n2));
                    break;
                }
                case NONE: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (marks.isEmpty()) {
            return Collections.emptyList();
        }
        MarkList marksList = MarkList.newBuilder().setMarkRecorderId(this.markRecorderRef.markRecorderId()).setThreadId(this.markRecorderRef.threadInfo().getId()).setThreadName(this.markRecorderRef.threadInfo().getName()).setMarks(new ArrayList(marks)).build();
        return Collections.singletonList(marksList);
    }

    private final class Kyoo<T>
    extends AbstractCollection<T>
    implements Queue<T> {
        private final T[] elements;
        private final long wIdx;
        private final int size;
        private int ri;

        Kyoo(T[] elements, long wIdx, int size) {
            this.elements = elements;
            this.wIdx = wIdx;
            this.size = size;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size - this.ri;
        }

        @Override
        public boolean offer(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove() {
            this.checkSize();
            return this.poll();
        }

        @Override
        public T poll() {
            if (this.size() == 0) {
                return null;
            }
            int rIdx = (int)(this.wIdx - 1L - (long)this.ri++ & SynchronizedMarkHolder.this.maxEventsMask);
            return this.elements[rIdx];
        }

        @Override
        public T element() {
            this.checkSize();
            return this.peek();
        }

        @Override
        public T peek() {
            if (this.size() == 0) {
                return null;
            }
            int rIdx = (int)(this.wIdx - 1L - (long)this.ri & SynchronizedMarkHolder.this.maxEventsMask);
            return this.elements[rIdx];
        }

        private void checkSize() {
            if (this.size() == 0) {
                throw new IllegalStateException();
            }
        }
    }
}

