/*
 * Decompiled with CFR 0.152.
 */
package com.internetitem.logback.elasticsearch.writer;

import com.internetitem.logback.elasticsearch.config.HttpRequestHeader;
import com.internetitem.logback.elasticsearch.config.HttpRequestHeaders;
import com.internetitem.logback.elasticsearch.config.Settings;
import com.internetitem.logback.elasticsearch.util.ErrorReporter;
import com.internetitem.logback.elasticsearch.writer.SafeWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.Collections;

public class ElasticsearchWriter
implements SafeWriter {
    private StringBuilder sendBuffer;
    private ErrorReporter errorReporter;
    private Settings settings;
    private Collection<HttpRequestHeader> headerList;
    private boolean bufferExceeded;

    public ElasticsearchWriter(ErrorReporter errorReporter, Settings settings, HttpRequestHeaders headers) {
        this.errorReporter = errorReporter;
        this.settings = settings;
        this.headerList = headers != null && headers.getHeaders() != null ? headers.getHeaders() : Collections.emptyList();
        this.sendBuffer = new StringBuilder();
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (this.bufferExceeded) {
            return;
        }
        this.sendBuffer.append(cbuf, off, len);
        if (this.sendBuffer.length() >= this.settings.getMaxQueueSize()) {
            this.errorReporter.logWarning("Send queue maximum size exceeded - log messages will be lost until the buffer is cleared");
            this.bufferExceeded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendData() throws IOException {
        if (this.sendBuffer.length() <= 0) {
            return;
        }
        HttpURLConnection urlConnection = (HttpURLConnection)this.settings.getUrl().openConnection();
        try {
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setReadTimeout(this.settings.getReadTimeout());
            urlConnection.setConnectTimeout(this.settings.getConnectTimeout());
            urlConnection.setRequestMethod("POST");
            String body = this.sendBuffer.toString();
            if (!this.headerList.isEmpty()) {
                for (HttpRequestHeader header : this.headerList) {
                    urlConnection.setRequestProperty(header.getName(), header.getValue());
                }
            }
            if (this.settings.getAuthentication() != null) {
                this.settings.getAuthentication().addAuth(urlConnection, body);
            }
            OutputStreamWriter writer = new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8");
            writer.write(body);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            int rc = urlConnection.getResponseCode();
            if (rc != 200) {
                String data = ElasticsearchWriter.slurpErrors(urlConnection);
                throw new IOException("Got response code [" + rc + "] from server with data " + data);
            }
        }
        finally {
            urlConnection.disconnect();
        }
        this.sendBuffer.setLength(0);
        if (this.bufferExceeded) {
            this.errorReporter.logInfo("Send queue cleared - log messages will no longer be lost");
            this.bufferExceeded = false;
        }
    }

    @Override
    public boolean hasPendingData() {
        return this.sendBuffer.length() != 0;
    }

    private static String slurpErrors(HttpURLConnection urlConnection) {
        try {
            int numRead;
            InputStream stream = urlConnection.getErrorStream();
            if (stream == null) {
                return "<no data>";
            }
            StringBuilder builder = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            char[] buf = new char[2048];
            while ((numRead = reader.read(buf)) > 0) {
                builder.append(buf, 0, numRead);
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "<error retrieving data: " + e.getMessage() + ">";
        }
    }
}

