/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FutureWriter
extends Writer {
    private final LinkedList<Future<String>> orderedFutures = new LinkedList();
    private final Writer internalWriter;
    private boolean closed = false;

    public FutureWriter(Writer writer) {
        this.internalWriter = writer;
    }

    public void enqueue(Future<String> future) throws IOException {
        if (this.closed) {
            throw new IOException("Writer is closed");
        }
        this.orderedFutures.add(future);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Writer is closed");
        }
        final String result = new String(cbuf, off, len);
        if (this.orderedFutures.isEmpty()) {
            this.internalWriter.write(result);
        } else {
            Future<String> future = new Future<String>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public String get() {
                    return result;
                }

                @Override
                public String get(long timeout, TimeUnit unit) {
                    return null;
                }
            };
            this.orderedFutures.add(future);
        }
    }

    @Override
    public void flush() throws IOException {
        for (Future future : this.orderedFutures) {
            try {
                String result = (String)future.get();
                this.internalWriter.write(result);
                this.internalWriter.flush();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        this.orderedFutures.clear();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.internalWriter.close();
        this.closed = true;
    }
}

