/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.tokenParser;

import io.pebbletemplates.pebble.lexer.Token;
import io.pebbletemplates.pebble.lexer.TokenStream;
import io.pebbletemplates.pebble.node.BodyNode;
import io.pebbletemplates.pebble.node.PrintNode;
import io.pebbletemplates.pebble.node.RenderableNode;
import io.pebbletemplates.pebble.node.expression.Expression;
import io.pebbletemplates.pebble.node.expression.FilterExpression;
import io.pebbletemplates.pebble.node.expression.FilterInvocationExpression;
import io.pebbletemplates.pebble.node.expression.RenderableNodeExpression;
import io.pebbletemplates.pebble.parser.Parser;
import io.pebbletemplates.pebble.tokenParser.TokenParser;
import java.util.ArrayList;

public class FilterTokenParser
implements TokenParser {
    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        ArrayList<FilterInvocationExpression> filterInvocationExpressions = new ArrayList<FilterInvocationExpression>();
        filterInvocationExpressions.add(parser.getExpressionParser().parseFilterInvocationExpression());
        while (stream.current().test(Token.Type.OPERATOR, "|")) {
            stream.next();
            filterInvocationExpressions.add(parser.getExpressionParser().parseFilterInvocationExpression());
        }
        stream.expect(Token.Type.EXECUTE_END);
        BodyNode body = parser.subparse(tkn -> tkn.test(Token.Type.NAME, "endfilter"));
        stream.next();
        stream.expect(Token.Type.EXECUTE_END);
        Expression<Object> lastExpression = new RenderableNodeExpression(body, stream.current().getLineNumber());
        for (Expression expression : filterInvocationExpressions) {
            FilterExpression filterExpression = new FilterExpression();
            filterExpression.setRight(expression);
            filterExpression.setLeft(lastExpression);
            lastExpression = filterExpression;
        }
        return new PrintNode(lastExpression, lineNumber);
    }

    @Override
    public String getTag() {
        return "filter";
    }
}

