/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node.expression;

import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MapExpression
implements Expression<Map<?, ?>> {
    private final Map<Expression<?>, Expression<?>> entries;
    private final int lineNumber;

    public MapExpression(int lineNumber) {
        this.entries = Collections.emptyMap();
        this.lineNumber = lineNumber;
    }

    public MapExpression(Map<Expression<?>, Expression<?>> entries, int lineNumber) {
        this.entries = entries == null ? Collections.emptyMap() : entries;
        this.lineNumber = lineNumber;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Map<?, ?> evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
        HashMap<Object, Object> returnEntries = new HashMap<Object, Object>(Long.valueOf(Math.round(Math.ceil((double)this.entries.size() / 0.75))).intValue());
        for (Map.Entry<Expression<?>, Expression<?>> entry : this.entries.entrySet()) {
            Expression<?> keyExpr = entry.getKey();
            Expression<?> valueExpr = entry.getValue();
            Object key = keyExpr == null ? null : (Object)keyExpr.evaluate(self, context);
            Object value = valueExpr == null ? null : (Object)valueExpr.evaluate(self, context);
            returnEntries.put(key, value);
        }
        return returnEntries;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }
}

