/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node.expression;

import com.mitchellbosecke.pebble.error.AttributeNotFoundException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.core.DefaultFilter;
import com.mitchellbosecke.pebble.extension.escaper.EscapeFilter;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.expression.BinaryExpression;
import com.mitchellbosecke.pebble.node.expression.FilterInvocationExpression;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.util.Map;

public class FilterExpression
extends BinaryExpression<Object> {
    private Filter filter = null;

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContext context) {
        Object input;
        FilterInvocationExpression filterInvocation = (FilterInvocationExpression)this.getRightExpression();
        ArgumentsNode args = filterInvocation.getArgs();
        String filterName = filterInvocation.getFilterName();
        if (this.filter == null) {
            this.filter = context.getExtensionRegistry().getFilter(filterInvocation.getFilterName());
        }
        if (this.filter == null) {
            throw new PebbleException(null, String.format("Filter [%s] does not exist.", filterName), this.getLineNumber(), self.getName());
        }
        Map<String, Object> namedArguments = args.getArgumentMap(self, context, this.filter);
        if (this.filter instanceof DefaultFilter) {
            try {
                input = this.getLeftExpression().evaluate(self, context);
            }
            catch (AttributeNotFoundException ex) {
                input = null;
            }
        } else {
            input = this.getLeftExpression().evaluate(self, context);
        }
        if (input instanceof SafeString && !(this.filter instanceof EscapeFilter)) {
            input = input.toString();
        }
        return this.filter.apply(input, namedArguments);
    }
}

