/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.spring.servlet;

import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import io.pebbletemplates.spring.context.Beans;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class PebbleView
extends AbstractTemplateView {
    public static final String REQUEST_VARIABLE_NAME = "request";
    public static final String RESPONSE_VARIABLE_NAME = "response";
    public static final String SESSION_VARIABLE_NAME = "session";
    private static final String BEANS_VARIABLE_NAME = "beans";
    private static final int NANO_PER_SECOND = 1000000;
    private static final Logger TIMER_LOGGER = LoggerFactory.getLogger((String)(PebbleView.class.getName() + ".timer"));
    private String characterEncoding = "UTF-8";
    private PebbleEngine pebbleEngine;
    private String templateName;

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        long startNanoTime = System.nanoTime();
        this.setCharacterEncoding(response);
        this.addVariablesToModel(model, request, response);
        this.evaluateTemplate(model, request, response);
        this.logElapsedTime(startNanoTime, request);
    }

    private void setCharacterEncoding(HttpServletResponse response) {
        if (this.characterEncoding != null) {
            response.setCharacterEncoding(this.characterEncoding);
        }
    }

    private void addVariablesToModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        model.put(BEANS_VARIABLE_NAME, new Beans(this.getApplicationContext()));
        model.put(REQUEST_VARIABLE_NAME, request);
        model.put(RESPONSE_VARIABLE_NAME, response);
        model.put(SESSION_VARIABLE_NAME, request.getSession(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateTemplate(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws IOException, PebbleException {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        PrintWriter writer = response.getWriter();
        try {
            PebbleTemplate template = this.pebbleEngine.getTemplate(this.templateName);
            template.evaluate((Writer)writer, model, locale);
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    private void logElapsedTime(long startNanoTime, HttpServletRequest request) {
        if (TIMER_LOGGER.isDebugEnabled()) {
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
            long endNanoTime = System.nanoTime();
            long elapsed = endNanoTime - startNanoTime;
            long elapsedMs = elapsed / 1000000L;
            TIMER_LOGGER.debug("Pebble template \"{}\" with locale {} processed in {} nanoseconds (approx. {}ms)", new Object[]{this.templateName, locale, elapsed, elapsedMs});
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setPebbleEngine(PebbleEngine pebbleEngine) {
        this.pebbleEngine = pebbleEngine;
    }

    public void setTemplateName(String name) {
        this.templateName = name;
    }
}

