/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.boot.autoconfigure;

import io.pebbletemplates.boot.autoconfigure.AbstractPebbleConfiguration;
import io.pebbletemplates.boot.autoconfigure.PebbleProperties;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.loader.ClasspathLoader;
import io.pebbletemplates.spring.reactive.PebbleReactiveViewResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
class PebbleReactiveWebConfiguration
extends AbstractPebbleConfiguration {
    PebbleReactiveWebConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"pebbleReactiveViewResolver"})
    PebbleReactiveViewResolver pebbleReactiveViewResolver(PebbleProperties properties, PebbleEngine pebbleEngine) {
        PebbleReactiveViewResolver resolver = new PebbleReactiveViewResolver(pebbleEngine);
        PropertyMapper map = PropertyMapper.get();
        map.from(() -> {
            String prefix = properties.getPrefix();
            if (pebbleEngine.getLoader() instanceof ClasspathLoader) {
                prefix = this.stripLeadingSlash(properties.getPrefix());
            }
            return prefix;
        }).to(arg_0 -> ((PebbleReactiveViewResolver)resolver).setPrefix(arg_0));
        map.from(properties::getSuffix).to(arg_0 -> ((PebbleReactiveViewResolver)resolver).setSuffix(arg_0));
        map.from(properties::getViewNames).to(arg_0 -> ((PebbleReactiveViewResolver)resolver).setViewNames(arg_0));
        map.from(properties::getRequestContextAttribute).to(arg_0 -> ((PebbleReactiveViewResolver)resolver).setRequestContextAttribute(arg_0));
        map.from(properties.getReactive()::getMediaTypes).to(arg_0 -> ((PebbleReactiveViewResolver)resolver).setSupportedMediaTypes(arg_0));
        resolver.setOrder(0x7FFFFFF5);
        return resolver;
    }
}

