/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.boot.autoconfigure;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;

@ConfigurationProperties(value="pebble")
public class PebbleProperties {
    private static final MimeType DEFAULT_CONTENT_TYPE = MimeType.valueOf((String)"text/html");
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String DEFAULT_PREFIX = "/templates/";
    public static final String DEFAULT_SUFFIX = ".peb";
    private Locale defaultLocale;
    private boolean strictVariables;
    private boolean greedyMatchMethod;
    private final Servlet servlet = new Servlet(this::getCharset);
    private final Reactive reactive = new Reactive();
    private String @Nullable [] viewNames;
    private @Nullable String requestContextAttribute;
    private Charset charset = DEFAULT_CHARSET;
    private boolean checkTemplateLocation = true;
    private String prefix = "/templates/";
    private String suffix = ".peb";

    public Servlet getServlet() {
        return this.servlet;
    }

    public Reactive getReactive() {
        return this.reactive;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String @Nullable [] getViewNames() {
        return this.viewNames;
    }

    public void setViewNames(String @Nullable [] viewNames) {
        this.viewNames = viewNames;
    }

    public @Nullable String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setRequestContextAttribute(@Nullable String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetName() {
        return this.charset.name();
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isCheckTemplateLocation() {
        return this.checkTemplateLocation;
    }

    public void setCheckTemplateLocation(boolean checkTemplateLocation) {
        this.checkTemplateLocation = checkTemplateLocation;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public boolean isStrictVariables() {
        return this.strictVariables;
    }

    public void setStrictVariables(boolean strictVariables) {
        this.strictVariables = strictVariables;
    }

    public boolean isGreedyMatchMethod() {
        return this.greedyMatchMethod;
    }

    public void setGreedyMatchMethod(boolean greedyMatchMethod) {
        this.greedyMatchMethod = greedyMatchMethod;
    }

    public static class Servlet {
        private boolean allowRequestOverride = false;
        private boolean allowSessionOverride = false;
        private boolean cache = true;
        private MimeType contentType = DEFAULT_CONTENT_TYPE;
        private boolean exposeRequestAttributes = false;
        private boolean exposeSessionAttributes = false;
        private boolean exposeSpringMacroHelpers = true;
        private final Supplier<@Nullable Charset> charset;

        public Servlet() {
            this.charset = () -> null;
        }

        private Servlet(Supplier<@Nullable Charset> charset) {
            this.charset = charset;
        }

        public boolean isAllowRequestOverride() {
            return this.allowRequestOverride;
        }

        public void setAllowRequestOverride(boolean allowRequestOverride) {
            this.allowRequestOverride = allowRequestOverride;
        }

        public boolean isAllowSessionOverride() {
            return this.allowSessionOverride;
        }

        public void setAllowSessionOverride(boolean allowSessionOverride) {
            this.allowSessionOverride = allowSessionOverride;
        }

        public boolean isCache() {
            return this.cache;
        }

        public void setCache(boolean cache) {
            this.cache = cache;
        }

        public MimeType getContentType() {
            Charset charset;
            if (this.contentType != null && this.contentType.getCharset() == null && (charset = this.charset.get()) != null) {
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("charset", charset.name());
                parameters.putAll(this.contentType.getParameters());
                return new MimeType(this.contentType, parameters);
            }
            return this.contentType;
        }

        public void setContentType(MimeType contentType) {
            this.contentType = contentType;
        }

        public boolean isExposeRequestAttributes() {
            return this.exposeRequestAttributes;
        }

        public void setExposeRequestAttributes(boolean exposeRequestAttributes) {
            this.exposeRequestAttributes = exposeRequestAttributes;
        }

        public boolean isExposeSessionAttributes() {
            return this.exposeSessionAttributes;
        }

        public void setExposeSessionAttributes(boolean exposeSessionAttributes) {
            this.exposeSessionAttributes = exposeSessionAttributes;
        }

        public boolean isExposeSpringMacroHelpers() {
            return this.exposeSpringMacroHelpers;
        }

        public void setExposeSpringMacroHelpers(boolean exposeSpringMacroHelpers) {
            this.exposeSpringMacroHelpers = exposeSpringMacroHelpers;
        }
    }

    public static class Reactive {
        private @Nullable List<MediaType> mediaTypes;

        public @Nullable List<MediaType> getMediaTypes() {
            return this.mediaTypes;
        }

        public void setMediaTypes(@Nullable List<MediaType> mediaTypes) {
            this.mediaTypes = mediaTypes;
        }
    }
}

