/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava3;

import io.opentracing.Tracer;
import io.opentracing.rxjava3.RxTracer;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableInternalHelper;
import io.reactivex.rxjava3.internal.subscribers.LambdaSubscriber;
import java.util.Objects;
import org.reactivestreams.Subscription;

public class TracingSubscriber<T>
implements FlowableSubscriber<T>,
Subscription {
    private Subscription upstream;
    private final RxTracer rxTracer;
    private final FlowableSubscriber<T> subscriber;

    private TracingSubscriber(FlowableSubscriber<T> subscriber, String operationName, Tracer tracer) {
        this.rxTracer = new RxTracer(operationName, tracer);
        this.subscriber = subscriber;
    }

    public void request(long l) {
        this.upstream.request(l);
    }

    public void cancel() {
        this.upstream.cancel();
    }

    public void onSubscribe(Subscription s) {
        this.upstream = s;
        try {
            this.subscriber.onSubscribe((Subscription)this);
        }
        finally {
            this.rxTracer.onSubscribe();
        }
    }

    public void onNext(T o) {
        this.subscriber.onNext(o);
    }

    public void onError(Throwable t) {
        try {
            this.subscriber.onError(t);
        }
        finally {
            this.rxTracer.onError(t);
        }
    }

    public void onComplete() {
        try {
            this.subscriber.onComplete();
        }
        finally {
            this.rxTracer.onComplete();
        }
    }

    public static <T> FlowableSubscriber<T> create(String operationName, Tracer tracer) {
        return TracingSubscriber.create(Functions.emptyConsumer(), (Consumer<? super Throwable>)Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION, (Consumer<? super Subscription>)FlowableInternalHelper.RequestMax.INSTANCE, operationName, tracer);
    }

    public static <T> FlowableSubscriber<T> create(Consumer<? super T> onNext, String operationName, Tracer tracer) {
        return TracingSubscriber.create(onNext, (Consumer<? super Throwable>)Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION, (Consumer<? super Subscription>)FlowableInternalHelper.RequestMax.INSTANCE, operationName, tracer);
    }

    public static <T> FlowableSubscriber<T> create(Consumer<? super T> onNext, Consumer<? super Throwable> onError, String operationName, Tracer tracer) {
        return TracingSubscriber.create(onNext, onError, Functions.EMPTY_ACTION, (Consumer<? super Subscription>)FlowableInternalHelper.RequestMax.INSTANCE, operationName, tracer);
    }

    public static <T> FlowableSubscriber<T> create(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, String operationName, Tracer tracer) {
        return TracingSubscriber.create(onNext, onError, onComplete, (Consumer<? super Subscription>)FlowableInternalHelper.RequestMax.INSTANCE, operationName, tracer);
    }

    public static <T> FlowableSubscriber<T> create(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Consumer<? super Subscription> onSubscribe, String operationName, Tracer tracer) {
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        Objects.requireNonNull(tracer, "tracer can not be null");
        return TracingSubscriber.create(new LambdaSubscriber(onNext, onError, onComplete, onSubscribe), operationName, tracer);
    }

    public static <T> FlowableSubscriber<T> create(FlowableSubscriber<T> subscriber, String operationName, Tracer tracer) {
        return new TracingSubscriber<T>(subscriber, operationName, tracer);
    }
}

