/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava3;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.rxjava3.SpanHolder;

class TracingRunnable
implements Runnable {
    private final Runnable runnable;
    private final Tracer tracer;
    private final Span span;

    TracingRunnable(Runnable runnable, Tracer tracer) {
        this.runnable = runnable;
        this.tracer = tracer;
        this.span = this.getSpan(tracer);
    }

    private Span getSpan(Tracer tracer) {
        if (SpanHolder.getSpan() != null) {
            Span span = SpanHolder.getSpan();
            SpanHolder.clear();
            return span;
        }
        return tracer.activeSpan();
    }

    @Override
    public void run() {
        Scope scope = null;
        if (this.span != null) {
            scope = this.tracer.scopeManager().activate(this.span);
        }
        try {
            this.runnable.run();
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

