/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava2;

import io.opentracing.ActiveSpan;
import io.opentracing.Tracer;
import io.opentracing.rxjava2.TracingObserver;
import io.opentracing.rxjava2.TracingRunnable;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.plugins.RxJavaPlugins;

public class TracingRxJava2Utils {
    public static void enableTracing() {
        TracingRxJava2Utils.enableTracing(GlobalTracer.get());
    }

    public static void enableTracing(final Tracer tracer) {
        RxJavaPlugins.setScheduleHandler((Function)new Function<Runnable, Runnable>(){

            public Runnable apply(Runnable runnable) throws Exception {
                return new TracingRunnable(runnable, tracer);
            }
        });
        RxJavaPlugins.setOnObservableSubscribe((BiFunction)new BiFunction<Observable, Observer, Observer>(){

            public Observer apply(Observable observable, Observer observer) throws Exception {
                try (ActiveSpan activeSpan = tracer.buildSpan(observable.getClass().getSimpleName()).startActive();){
                    activeSpan.setTag(Tags.COMPONENT.getKey(), "rxjava-2");
                    TracingObserver tracingObserver = new TracingObserver(observer, activeSpan);
                    return tracingObserver;
                }
            }
        });
    }
}

