/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava2;

import io.opentracing.ActiveSpan;
import io.opentracing.Tracer;

class TracingRunnable
implements Runnable {
    private final Runnable runnable;
    private final ActiveSpan.Continuation continuation;

    TracingRunnable(Runnable runnable, Tracer tracer) {
        this.runnable = runnable;
        ActiveSpan activeSpan = tracer.activeSpan();
        this.continuation = activeSpan != null ? activeSpan.capture() : null;
    }

    @Override
    public void run() {
        ActiveSpan activeSpan = null;
        if (this.continuation != null) {
            activeSpan = this.continuation.activate();
        }
        try {
            this.runnable.run();
        }
        finally {
            if (activeSpan != null) {
                activeSpan.deactivate();
            }
        }
    }
}

