/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.rxjava.AbstractTracingSubscriber;
import io.opentracing.rxjava.TracingAction;
import io.opentracing.util.GlobalTracer;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.observers.SafeSubscriber;
import rx.plugins.RxJavaHooks;

public class TracingRxJavaUtils {
    public static void enableTracing() {
        TracingRxJavaUtils.enableTracing(GlobalTracer.get());
    }

    public static void enableTracing(final Tracer tracer) {
        RxJavaHooks.setOnScheduleAction((Func1)new Func1<Action0, Action0>(){

            public Action0 call(Action0 action0) {
                return new TracingAction(action0, tracer);
            }
        });
        RxJavaHooks.setOnObservableStart((Func2)new Func2<Observable, Observable.OnSubscribe, Observable.OnSubscribe>(){

            public Observable.OnSubscribe call(Observable observable, final Observable.OnSubscribe onSubscribe) {
                return new Observable.OnSubscribe<Subscriber>(){

                    public void call(Subscriber subscriber) {
                        SafeSubscriber safeSubscriber;
                        Subscriber subscriber2;
                        Scope scope = null;
                        if (subscriber instanceof SafeSubscriber && (subscriber2 = (safeSubscriber = (SafeSubscriber)subscriber).getActual()) instanceof AbstractTracingSubscriber) {
                            AbstractTracingSubscriber tracingSubscriber = (AbstractTracingSubscriber)subscriber2;
                            Span span = tracingSubscriber.getSpan();
                            scope = tracer.scopeManager().activate(span);
                        }
                        onSubscribe.call((Object)subscriber);
                        if (scope != null) {
                            scope.close();
                        }
                    }
                };
            }
        });
    }
}

