/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.Tracer;
import io.opentracing.rxjava.AbstractTracingSubscriber;
import io.opentracing.rxjava.TracingEmptyAction;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.internal.util.InternalObservableUtils;

public class TracingActionSubscriber<T>
extends AbstractTracingSubscriber<T> {
    private final Action1<? super T> onNext;
    private final Action1<Throwable> onError;
    private final Action0 onCompleted;

    public TracingActionSubscriber(String operationName, Tracer tracer) {
        this(TracingEmptyAction.empty(), operationName, tracer);
    }

    public TracingActionSubscriber(Action1<? super T> onNext, String operationName, Tracer tracer) {
        this(onNext, (Action1<Throwable>)InternalObservableUtils.ERROR_NOT_IMPLEMENTED, operationName, tracer);
    }

    public TracingActionSubscriber(Action1<? super T> onNext, Action1<Throwable> onError, String operationName, Tracer tracer) {
        this(onNext, onError, TracingEmptyAction.empty(), operationName, tracer);
    }

    public TracingActionSubscriber(Action1<? super T> onNext, Action1<Throwable> onError, Action0 onCompleted, String operationName, Tracer tracer) {
        super(operationName, tracer);
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onCompleted == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        this.onNext = onNext;
        this.onError = onError;
        this.onCompleted = onCompleted;
    }

    @Override
    public void onNext(T t) {
        this.onNext.call(t);
    }

    @Override
    public void onError(Throwable e) {
        try {
            this.onError.call((Object)e);
        }
        finally {
            super.onError(e);
        }
    }

    @Override
    public void onCompleted() {
        try {
            this.onCompleted.call();
        }
        finally {
            super.onCompleted();
        }
    }
}

