/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.Tracer;
import io.opentracing.rxjava.AbstractTracingSubscriber;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;

class TracingSubscriber<T>
extends AbstractTracingSubscriber<T> {
    private final Subscriber<T> subscriber;

    TracingSubscriber(Subscriber<T> subscriber, String operationName, Tracer tracer) {
        super(operationName, tracer);
        if (subscriber == null) {
            throw new IllegalArgumentException("subscriber can not be null");
        }
        this.subscriber = subscriber;
        subscriber.add((Subscription)this);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.subscriber.onStart();
    }

    @Override
    public void onNext(T o) {
        this.subscriber.onNext(o);
    }

    @Override
    public void onError(Throwable t) {
        try {
            this.subscriber.onError(t);
        }
        finally {
            super.onError(t);
        }
    }

    @Override
    public void onCompleted() {
        try {
            this.subscriber.onCompleted();
        }
        finally {
            super.onCompleted();
        }
    }

    public void setProducer(Producer p) {
        this.subscriber.setProducer(p);
    }
}

