/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.ActiveSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.rxjava.SpanContextHolder;
import io.opentracing.rxjava.TracingSubscriber;
import io.opentracing.tag.Tags;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

class TracingOnSubscribe<T>
implements Observable.OnSubscribe<T> {
    private final Observable.OnSubscribe<T> onSubscribe;
    private final Tracer tracer;
    private final Span span;

    TracingOnSubscribe(Observable.OnSubscribe<T> onSubscribe, Tracer tracer) {
        this.onSubscribe = onSubscribe;
        this.tracer = tracer;
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(onSubscribe.getClass().getSimpleName());
        SpanContext parentContext = SpanContextHolder.get();
        if (parentContext != null) {
            spanBuilder.addReference("child_of", parentContext);
        }
        this.span = spanBuilder.startManual();
        if (onSubscribe.getClass().getSimpleName().isEmpty()) {
            this.span.setOperationName(onSubscribe.getClass().getName());
        }
        SpanContextHolder.set(this.span.context());
    }

    public void call(Subscriber<? super T> subscriber) {
        SpanContextHolder.clear();
        try (ActiveSpan activeSpan = this.tracer.makeActive(this.span);){
            if (this.onSubscribe.getClass().getSimpleName().isEmpty()) {
                activeSpan.setOperationName(this.onSubscribe.getClass().getName());
            }
            activeSpan.setTag(Tags.COMPONENT.getKey(), "rxjava-1");
            TracingSubscriber t = new TracingSubscriber(subscriber, activeSpan);
            subscriber.add((Subscription)t);
            this.onSubscribe.call((Object)t);
        }
    }
}

