/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.apache.http.client;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.apache.http.client.ApacheClientSpanDecorator;
import io.opentracing.contrib.apache.http.client.Constants;
import io.opentracing.contrib.apache.http.client.TracingHttpClientBuilder;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;

public class TracingClientExec
implements ClientExecChain {
    static final String COMPONENT_NAME = "apache-httpclient";
    protected static final String SPAN_PROP = TracingHttpClientBuilder.class.getName() + ".currentSpan";
    protected static final String REDIRECT_COUNT = TracingHttpClientBuilder.class.getName() + ".redirectCount";
    private final RedirectStrategy redirectStrategy;
    private final ClientExecChain requestExecutor;
    private final boolean redirectHandlingDisabled;
    private final boolean injectDisabled;
    private final Tracer tracer;
    private final List<ApacheClientSpanDecorator> spanDecorators;

    public TracingClientExec(ClientExecChain clientExecChain, RedirectStrategy redirectStrategy, boolean redirectHandlingDisabled, boolean injectDisabled, Tracer tracer, List<ApacheClientSpanDecorator> spanDecorators) {
        this.requestExecutor = clientExecChain;
        this.redirectStrategy = redirectStrategy;
        this.redirectHandlingDisabled = redirectHandlingDisabled;
        this.injectDisabled = injectDisabled;
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<ApacheClientSpanDecorator>(spanDecorators);
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext clientContext, HttpExecutionAware execAware) throws IOException, HttpException {
        Span localSpan = (Span)clientContext.getAttribute(SPAN_PROP, Span.class);
        CloseableHttpResponse response = null;
        try {
            if (localSpan == null) {
                localSpan = this.handleLocalSpan((HttpRequest)request, clientContext);
            }
            CloseableHttpResponse closeableHttpResponse = response = this.handleNetworkProcessing(localSpan, route, request, clientContext, execAware);
            return closeableHttpResponse;
        }
        catch (Exception e) {
            localSpan.finish();
            throw e;
        }
        finally {
            if (response != null) {
                Integer redirectCount = (Integer)clientContext.getAttribute(REDIRECT_COUNT, Integer.class);
                if (!this.redirectHandlingDisabled && clientContext.getRequestConfig().isRedirectsEnabled() && this.redirectStrategy.isRedirected((HttpRequest)request, (HttpResponse)response, (HttpContext)clientContext) && (redirectCount = Integer.valueOf(redirectCount + 1)) < clientContext.getRequestConfig().getMaxRedirects()) {
                    clientContext.setAttribute(REDIRECT_COUNT, (Object)redirectCount);
                } else {
                    localSpan.finish();
                }
            }
        }
    }

    protected Span handleLocalSpan(HttpRequest httpRequest, HttpClientContext clientContext) {
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(httpRequest.getRequestLine().getMethod()).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME);
        if (clientContext.getAttribute(Constants.PARENT_CONTEXT, SpanContext.class) != null) {
            spanBuilder.ignoreActiveSpan().asChildOf((SpanContext)clientContext.getAttribute(Constants.PARENT_CONTEXT, SpanContext.class));
        }
        Span localSpan = spanBuilder.start();
        clientContext.setAttribute(SPAN_PROP, (Object)localSpan);
        clientContext.setAttribute(REDIRECT_COUNT, (Object)0);
        return localSpan;
    }

    /*
     * Exception decompiling
     */
    protected CloseableHttpResponse handleNetworkProcessing(Span parentSpan, HttpRoute route, HttpRequestWrapper request, HttpClientContext clientContext, HttpExecutionAware execAware) throws IOException, HttpException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

