/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent.jaeger;

import io.opentracing.contrib.specialagent.common.Configuration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TracerParameters {
    static final String JAEGER_PREFIX = "JAEGER_";
    private static final Logger logger = Logger.getLogger(TracerParameters.class.getName());

    private TracerParameters() {
    }

    public static void loadParameters() {
        Properties props = Configuration.loadConfigurationFile();
        TracerParameters.loadParametersIntoSystemProperties(props);
    }

    static void loadParametersIntoSystemProperties(Properties props) {
        for (String propName : props.stringPropertyNames()) {
            if (!propName.startsWith(JAEGER_PREFIX) || System.getProperty(propName) != null) continue;
            String propValue = props.getProperty(propName);
            System.setProperty(propName, propValue);
            logger.log(Level.INFO, "Set System property " + propName + "=" + propValue + " from Tracer configuration file");
        }
    }
}

