/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.util;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.util.ThreadLocalScopeManager;

public class ThreadLocalScope
implements Scope {
    private final ThreadLocalScopeManager scopeManager;
    private final Span wrapped;
    private final boolean finishOnClose;
    private final ThreadLocalScope toRestore;

    ThreadLocalScope(ThreadLocalScopeManager scopeManager, Span wrapped) {
        this(scopeManager, wrapped, false);
    }

    ThreadLocalScope(ThreadLocalScopeManager scopeManager, Span wrapped, boolean finishOnClose) {
        this.scopeManager = scopeManager;
        this.wrapped = wrapped;
        this.finishOnClose = finishOnClose;
        this.toRestore = scopeManager.tlsScope.get();
        scopeManager.tlsScope.set(this);
    }

    @Override
    public void close() {
        if (this.scopeManager.tlsScope.get() != this) {
            return;
        }
        if (this.finishOnClose) {
            this.wrapped.finish();
        }
        this.scopeManager.tlsScope.set(this.toRestore);
    }

    @Override
    public Span span() {
        return this.wrapped;
    }
}

