/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.util;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.util.AutoFinishScopeManager;
import java.util.concurrent.atomic.AtomicInteger;

public class AutoFinishScope
implements Scope {
    final AutoFinishScopeManager manager;
    final AtomicInteger refCount;
    private final Span wrapped;
    private final AutoFinishScope toRestore;

    AutoFinishScope(AutoFinishScopeManager manager, AtomicInteger refCount, Span wrapped) {
        this.manager = manager;
        this.refCount = refCount;
        this.wrapped = wrapped;
        this.toRestore = manager.tlsScope.get();
        manager.tlsScope.set(this);
    }

    public Continuation capture() {
        return new Continuation();
    }

    @Override
    public void close() {
        if (this.manager.tlsScope.get() != this) {
            return;
        }
        if (this.refCount.decrementAndGet() == 0) {
            this.wrapped.finish();
        }
        this.manager.tlsScope.set(this.toRestore);
    }

    @Override
    public Span span() {
        return this.wrapped;
    }

    public class Continuation {
        public Continuation() {
            AutoFinishScope.this.refCount.incrementAndGet();
        }

        public AutoFinishScope activate() {
            return new AutoFinishScope(AutoFinishScope.this.manager, AutoFinishScope.this.refCount, AutoFinishScope.this.wrapped);
        }
    }
}

