/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import javax.annotation.Nullable;

public final class OpenTelemetrySdkBuilder {
    private ContextPropagators propagators = ContextPropagators.noop();
    @Nullable
    private SdkTracerProvider tracerProvider;
    @Nullable
    private SdkMeterProvider meterProvider;

    OpenTelemetrySdkBuilder() {
    }

    public OpenTelemetrySdkBuilder setTracerProvider(SdkTracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setMeterProvider(SdkMeterProvider meterProvider) {
        this.meterProvider = meterProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setPropagators(ContextPropagators propagators) {
        this.propagators = propagators;
        return this;
    }

    public OpenTelemetrySdk buildAndRegisterGlobal() {
        OpenTelemetrySdk sdk = this.build();
        GlobalOpenTelemetry.set((OpenTelemetry)sdk);
        return sdk;
    }

    public OpenTelemetrySdk build() {
        SdkMeterProvider meterProvider;
        SdkTracerProvider tracerProvider = this.tracerProvider;
        if (tracerProvider == null) {
            tracerProvider = SdkTracerProvider.builder().build();
        }
        if ((meterProvider = this.meterProvider) == null) {
            meterProvider = SdkMeterProvider.builder().build();
        }
        return new OpenTelemetrySdk(tracerProvider, meterProvider, this.propagators);
    }
}

