/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.grpc.Context;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.common.ReadableKeyValuePairs;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.MonotonicClock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AttributesMap;
import io.opentelemetry.sdk.trace.IdsGenerator;
import io.opentelemetry.sdk.trace.RecordEventsReadableSpan;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.sdk.trace.Samplers;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

final class SpanBuilderSdk
implements Span.Builder {
    private static final TraceFlags TRACE_OPTIONS_SAMPLED = TraceFlags.builder().setIsSampled(true).build();
    private static final TraceFlags TRACE_OPTIONS_NOT_SAMPLED = TraceFlags.builder().setIsSampled(false).build();
    private final String spanName;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final SpanProcessor spanProcessor;
    private final TraceConfig traceConfig;
    private final Resource resource;
    private final IdsGenerator idsGenerator;
    private final Clock clock;
    @Nullable
    private Span parent;
    @Nullable
    private SpanContext remoteParent;
    private Span.Kind spanKind = Span.Kind.INTERNAL;
    @Nullable
    private AttributesMap attributes;
    @Nullable
    private List<Link> links;
    private int totalNumberOfLinksAdded = 0;
    private ParentType parentType = ParentType.CURRENT_CONTEXT;
    private long startEpochNanos = 0L;

    SpanBuilderSdk(String spanName, InstrumentationLibraryInfo instrumentationLibraryInfo, SpanProcessor spanProcessor, TraceConfig traceConfig, Resource resource, IdsGenerator idsGenerator, Clock clock) {
        this.spanName = spanName;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.spanProcessor = spanProcessor;
        this.traceConfig = traceConfig;
        this.resource = resource;
        this.idsGenerator = idsGenerator;
        this.clock = clock;
    }

    public Span.Builder setParent(Span parent) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.remoteParent = null;
        this.parentType = ParentType.EXPLICIT_PARENT;
        return this;
    }

    public Span.Builder setParent(SpanContext remoteParent) {
        this.remoteParent = Objects.requireNonNull(remoteParent, "remoteParent");
        this.parent = null;
        this.parentType = ParentType.EXPLICIT_REMOTE_PARENT;
        return this;
    }

    public Span.Builder setParent(Context context) {
        Objects.requireNonNull(context, "context");
        this.setParent(TracingContextUtils.getSpan((Context)context));
        return this;
    }

    public Span.Builder setNoParent() {
        this.parentType = ParentType.NO_PARENT;
        this.parent = null;
        this.remoteParent = null;
        return this;
    }

    public Span.Builder setSpanKind(Span.Kind spanKind) {
        this.spanKind = Objects.requireNonNull(spanKind, "spanKind");
        return this;
    }

    public Span.Builder addLink(SpanContext spanContext) {
        this.addLink(SpanData.Link.create(spanContext));
        return this;
    }

    public Span.Builder addLink(SpanContext spanContext, Attributes attributes) {
        int totalAttributeCount = attributes.size();
        this.addLink(SpanData.Link.create(spanContext, RecordEventsReadableSpan.copyAndLimitAttributes(attributes, this.traceConfig.getMaxNumberOfAttributesPerLink()), totalAttributeCount));
        return this;
    }

    public Span.Builder addLink(Link link) {
        Objects.requireNonNull(link, "link");
        ++this.totalNumberOfLinksAdded;
        if (this.links == null) {
            this.links = new ArrayList<Link>(this.traceConfig.getMaxNumberOfLinks());
        }
        if (this.links.size() == this.traceConfig.getMaxNumberOfLinks()) {
            return this;
        }
        this.links.add(link);
        return this;
    }

    public Span.Builder setAttribute(String key, String value) {
        return this.setAttribute(key, AttributeValue.stringAttributeValue((String)value));
    }

    public Span.Builder setAttribute(String key, long value) {
        return this.setAttribute(key, AttributeValue.longAttributeValue((long)value));
    }

    public Span.Builder setAttribute(String key, double value) {
        return this.setAttribute(key, AttributeValue.doubleAttributeValue((double)value));
    }

    public Span.Builder setAttribute(String key, boolean value) {
        return this.setAttribute(key, AttributeValue.booleanAttributeValue((boolean)value));
    }

    public Span.Builder setAttribute(String key, AttributeValue value) {
        Objects.requireNonNull(key, "key");
        if (value == null || value.getType() == AttributeValue.Type.STRING && value.getStringValue() == null) {
            if (this.attributes != null) {
                this.attributes.remove(key);
            }
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new AttributesMap((long)this.traceConfig.getMaxNumberOfAttributes());
        }
        if (this.traceConfig.shouldTruncateStringAttributeValues()) {
            value = StringUtils.truncateToSize((AttributeValue)value, (int)this.traceConfig.getMaxLengthOfAttributeValues());
        }
        this.attributes.put(key, value);
        return this;
    }

    public Span.Builder setStartTimestamp(long startTimestamp) {
        Utils.checkArgument((startTimestamp >= 0L ? 1 : 0) != 0, (String)"Negative startTimestamp");
        this.startEpochNanos = startTimestamp;
        return this;
    }

    public Span startSpan() {
        TraceId traceId;
        SpanContext parentContext = SpanBuilderSdk.parent(this.parentType, this.parent, this.remoteParent);
        SpanId spanId = this.idsGenerator.generateSpanId();
        TraceState traceState = TraceState.getDefault();
        if (parentContext == null || !parentContext.isValid()) {
            traceId = this.idsGenerator.generateTraceId();
            parentContext = null;
        } else {
            traceId = parentContext.getTraceId();
            traceState = parentContext.getTraceState();
        }
        List<Link> immutableLinks = this.links == null ? Collections.emptyList() : Collections.unmodifiableList(this.links);
        this.links = null;
        Object immutableAttributes = this.attributes == null ? Attributes.empty() : this.attributes;
        Sampler.SamplingResult samplingResult = this.traceConfig.getSampler().shouldSample(parentContext, traceId, this.spanName, this.spanKind, (ReadableAttributes)immutableAttributes, immutableLinks);
        Sampler.Decision samplingDecision = samplingResult.getDecision();
        SpanContext spanContext = SpanContext.create((TraceId)traceId, (SpanId)spanId, (TraceFlags)(Samplers.isSampled(samplingDecision) ? TRACE_OPTIONS_SAMPLED : TRACE_OPTIONS_NOT_SAMPLED), (TraceState)traceState);
        if (!Samplers.isRecording(samplingDecision)) {
            return DefaultSpan.create((SpanContext)spanContext);
        }
        Attributes samplingAttributes = samplingResult.getAttributes();
        if (!samplingAttributes.isEmpty()) {
            if (this.attributes == null) {
                this.attributes = new AttributesMap((long)this.traceConfig.getMaxNumberOfAttributes());
            }
            samplingAttributes.forEach((ReadableKeyValuePairs.KeyValueConsumer)new ReadableKeyValuePairs.KeyValueConsumer<AttributeValue>(){

                public void consume(String key, AttributeValue value) {
                    SpanBuilderSdk.this.attributes.put(key, value);
                }
            });
        }
        AttributesMap recordedAttributes = this.attributes;
        this.attributes = null;
        return RecordEventsReadableSpan.startSpan(spanContext, this.spanName, this.instrumentationLibraryInfo, this.spanKind, parentContext != null ? parentContext.getSpanId() : null, parentContext != null && parentContext.isRemote(), this.traceConfig, this.spanProcessor, SpanBuilderSdk.getClock(SpanBuilderSdk.parentSpan(this.parentType, this.parent), this.clock), this.resource, recordedAttributes, immutableLinks, this.totalNumberOfLinksAdded, this.startEpochNanos);
    }

    private static Clock getClock(Span parent, Clock clock) {
        if (parent instanceof RecordEventsReadableSpan) {
            RecordEventsReadableSpan parentRecordEventsSpan = (RecordEventsReadableSpan)parent;
            return parentRecordEventsSpan.getClock();
        }
        return MonotonicClock.create(clock);
    }

    @Nullable
    private static SpanContext parent(ParentType parentType, Span explicitParent, SpanContext remoteParent) {
        switch (parentType) {
            case NO_PARENT: {
                return null;
            }
            case CURRENT_CONTEXT: {
                return TracingContextUtils.getCurrentSpan().getContext();
            }
            case EXPLICIT_PARENT: {
                return explicitParent.getContext();
            }
            case EXPLICIT_REMOTE_PARENT: {
                return remoteParent;
            }
        }
        throw new IllegalStateException("Unknown parent type");
    }

    @Nullable
    private static Span parentSpan(ParentType parentType, Span explicitParent) {
        switch (parentType) {
            case CURRENT_CONTEXT: {
                return TracingContextUtils.getSpanWithoutDefault((Context)Context.current());
            }
            case EXPLICIT_PARENT: {
                return explicitParent;
            }
        }
        return null;
    }

    private static enum ParentType {
        CURRENT_CONTEXT,
        EXPLICIT_PARENT,
        EXPLICIT_REMOTE_PARENT,
        NO_PARENT;

    }
}

