/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.export;

import com.google.auto.value.AutoValue;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.common.DaemonThreadFactory;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AutoValue_IntervalMetricReader_InternalState;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

public final class IntervalMetricReader {
    private static final Logger logger = Logger.getLogger(IntervalMetricReader.class.getName());
    private final Exporter exporter;
    private final ScheduledExecutorService scheduler;

    public void shutdown() {
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            this.exporter.run();
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            this.exporter.shutdown();
        }
    }

    public static Builder builder() {
        return new Builder(InternalState.builder());
    }

    public static Builder builderFromDefaultSources() {
        return (Builder)((Builder)IntervalMetricReader.builder().readEnvironmentVariables()).readSystemProperties();
    }

    private IntervalMetricReader(InternalState internalState) {
        this.exporter = new Exporter(internalState);
        this.scheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("IntervalMetricReader"));
        this.scheduler.scheduleAtFixedRate(this.exporter, internalState.getExportIntervalMillis(), internalState.getExportIntervalMillis(), TimeUnit.MILLISECONDS);
    }

    @AutoValue
    @Immutable
    static abstract class InternalState {
        static final long DEFAULT_INTERVAL_MILLIS = 60000L;

        InternalState() {
        }

        abstract MetricExporter getMetricExporter();

        abstract long getExportIntervalMillis();

        abstract Collection<MetricProducer> getMetricProducers();

        static Builder builder() {
            return new AutoValue_IntervalMetricReader_InternalState.Builder().setExportIntervalMillis(60000L);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setExportIntervalMillis(long var1);

            abstract Builder setMetricExporter(MetricExporter var1);

            abstract Builder setMetricProducers(Collection<MetricProducer> var1);

            abstract InternalState build();
        }
    }

    private static final class Exporter
    implements Runnable {
        private final InternalState internalState;

        private Exporter(InternalState internalState) {
            this.internalState = internalState;
        }

        @Override
        public void run() {
            try {
                ArrayList<MetricData> metricsList = new ArrayList<MetricData>();
                for (MetricProducer metricProducer : this.internalState.getMetricProducers()) {
                    metricsList.addAll(metricProducer.collectAllMetrics());
                }
                this.internalState.getMetricExporter().export(Collections.unmodifiableList(metricsList));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Metric Exporter threw an Exception", e);
            }
        }

        void shutdown() {
            this.internalState.getMetricExporter().shutdown();
        }
    }

    public static final class Builder
    extends ConfigBuilder<Builder> {
        private final InternalState.Builder optionsBuilder;
        private static final String KEY_EXPORT_INTERVAL = "otel.imr.export.interval";

        private Builder(InternalState.Builder optionsBuilder) {
            this.optionsBuilder = optionsBuilder;
        }

        public Builder setExportIntervalMillis(long exportIntervalMillis) {
            this.optionsBuilder.setExportIntervalMillis(exportIntervalMillis);
            return this;
        }

        public Builder setMetricExporter(MetricExporter metricExporter) {
            this.optionsBuilder.setMetricExporter(metricExporter);
            return this;
        }

        public Builder setMetricProducers(Collection<MetricProducer> metricProducers) {
            this.optionsBuilder.setMetricProducers(metricProducers);
            return this;
        }

        public IntervalMetricReader build() {
            InternalState internalState = this.optionsBuilder.build();
            Utils.checkArgument((internalState.getExportIntervalMillis() > 0L ? 1 : 0) != 0, (String)"Export interval must be positive");
            return new IntervalMetricReader(internalState);
        }

        @Override
        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            Long value = Builder.getLongProperty(KEY_EXPORT_INTERVAL, configMap = namingConvention.normalize(configMap));
            if (value != null) {
                this.setExportIntervalMillis(value);
            }
            return this;
        }
    }
}

