/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.common.Labels;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.LongCounter;
import io.opentelemetry.metrics.Meter;
import io.opentelemetry.sdk.common.DaemonThreadFactory;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public final class BatchSpanProcessor
implements SpanProcessor {
    private static final String WORKER_THREAD_NAME = BatchSpanProcessor.class.getSimpleName() + "_WorkerThread";
    private static final String EXPORTER_THREAD_NAME = BatchSpanProcessor.class.getSimpleName() + "_ExporterThread";
    private final Worker worker;
    private final Thread workerThread;
    private final boolean sampled;

    private BatchSpanProcessor(SpanExporter spanExporter, boolean sampled, long scheduleDelayMillis, int maxQueueSize, int maxExportBatchSize, int exporterTimeoutMillis) {
        this.worker = new Worker(spanExporter, scheduleDelayMillis, maxQueueSize, maxExportBatchSize, exporterTimeoutMillis);
        this.workerThread = new DaemonThreadFactory(WORKER_THREAD_NAME).newThread(this.worker);
        this.workerThread.start();
        this.sampled = sampled;
    }

    @Override
    public void onStart(ReadableSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (this.sampled && !span.getSpanContext().getTraceFlags().isSampled()) {
            return;
        }
        this.worker.addSpan(span);
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public void shutdown() {
        this.workerThread.interrupt();
        this.worker.shutdown();
    }

    @Override
    public void forceFlush() {
        this.worker.forceFlush();
    }

    public static Builder newBuilder(SpanExporter spanExporter) {
        return new Builder(spanExporter);
    }

    static /* synthetic */ String access$400() {
        return EXPORTER_THREAD_NAME;
    }

    public static final class Builder
    extends ConfigBuilder<Builder> {
        private static final String KEY_SCHEDULE_DELAY_MILLIS = "otel.bsp.schedule.delay";
        private static final String KEY_MAX_QUEUE_SIZE = "otel.bsp.max.queue";
        private static final String KEY_MAX_EXPORT_BATCH_SIZE = "otel.bsp.max.export.batch";
        private static final String KEY_EXPORT_TIMEOUT_MILLIS = "otel.bsp.export.timeout";
        private static final String KEY_SAMPLED = "otel.bsp.export.sampled";
        @VisibleForTesting
        static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 5000L;
        @VisibleForTesting
        static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
        @VisibleForTesting
        static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
        @VisibleForTesting
        static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
        @VisibleForTesting
        static final boolean DEFAULT_EXPORT_ONLY_SAMPLED = true;
        private final SpanExporter spanExporter;
        private long scheduleDelayMillis = 5000L;
        private int maxQueueSize = 2048;
        private int maxExportBatchSize = 512;
        private int exporterTimeoutMillis = 30000;
        private boolean exportOnlySampled = true;

        private Builder(SpanExporter spanExporter) {
            this.spanExporter = (SpanExporter)Utils.checkNotNull((Object)spanExporter, (String)"spanExporter");
        }

        @Override
        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            Boolean boolValue;
            Integer intValue;
            Long longValue = Builder.getLongProperty(KEY_SCHEDULE_DELAY_MILLIS, configMap = namingConvention.normalize(configMap));
            if (longValue != null) {
                this.setScheduleDelayMillis(longValue);
            }
            if ((intValue = Builder.getIntProperty(KEY_MAX_QUEUE_SIZE, configMap)) != null) {
                this.setMaxQueueSize(intValue);
            }
            if ((intValue = Builder.getIntProperty(KEY_MAX_EXPORT_BATCH_SIZE, configMap)) != null) {
                this.setMaxExportBatchSize(intValue);
            }
            if ((intValue = Builder.getIntProperty(KEY_EXPORT_TIMEOUT_MILLIS, configMap)) != null) {
                this.setExporterTimeoutMillis(intValue);
            }
            if ((boolValue = Builder.getBooleanProperty(KEY_SAMPLED, configMap)) != null) {
                this.setExportOnlySampled(boolValue);
            }
            return this;
        }

        public Builder setExportOnlySampled(boolean exportOnlySampled) {
            this.exportOnlySampled = exportOnlySampled;
            return this;
        }

        @VisibleForTesting
        boolean getExportOnlySampled() {
            return this.exportOnlySampled;
        }

        public Builder setScheduleDelayMillis(long scheduleDelayMillis) {
            this.scheduleDelayMillis = scheduleDelayMillis;
            return this;
        }

        @VisibleForTesting
        long getScheduleDelayMillis() {
            return this.scheduleDelayMillis;
        }

        public Builder setExporterTimeoutMillis(int exporterTimeoutMillis) {
            this.exporterTimeoutMillis = exporterTimeoutMillis;
            return this;
        }

        @VisibleForTesting
        int getExporterTimeoutMillis() {
            return this.exporterTimeoutMillis;
        }

        public Builder setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        @VisibleForTesting
        int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public Builder setMaxExportBatchSize(int maxExportBatchSize) {
            Utils.checkArgument((maxExportBatchSize > 0 ? 1 : 0) != 0, (String)"maxExportBatchSize must be positive.");
            this.maxExportBatchSize = maxExportBatchSize;
            return this;
        }

        @VisibleForTesting
        int getMaxExportBatchSize() {
            return this.maxExportBatchSize;
        }

        public BatchSpanProcessor build() {
            return new BatchSpanProcessor(this.spanExporter, this.exportOnlySampled, this.scheduleDelayMillis, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutMillis);
        }
    }

    private static final class Worker
    implements Runnable {
        private static final LongCounter.BoundLongCounter droppedSpans;
        private final ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory(BatchSpanProcessor.access$400()));
        private static final Logger logger;
        private final SpanExporter spanExporter;
        private final long scheduleDelayMillis;
        private final int maxQueueSize;
        private final int maxExportBatchSize;
        private final int halfMaxQueueSize;
        private final Object monitor = new Object();
        private final int exporterTimeoutMillis;
        @GuardedBy(value="monitor")
        private final List<ReadableSpan> spansList;

        private Worker(SpanExporter spanExporter, long scheduleDelayMillis, int maxQueueSize, int maxExportBatchSize, int exporterTimeoutMillis) {
            this.spanExporter = spanExporter;
            this.scheduleDelayMillis = scheduleDelayMillis;
            this.maxQueueSize = maxQueueSize;
            this.halfMaxQueueSize = maxQueueSize >> 1;
            this.maxExportBatchSize = maxExportBatchSize;
            this.spansList = new ArrayList<ReadableSpan>(maxQueueSize);
            this.exporterTimeoutMillis = exporterTimeoutMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSpan(ReadableSpan span) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.spansList.size() == this.maxQueueSize) {
                    droppedSpans.add(1L);
                    return;
                }
                this.spansList.add(span);
                if (this.spansList.size() >= this.halfMaxQueueSize) {
                    this.monitor.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                ArrayList<ReadableSpan> spansCopy;
                Object object = this.monitor;
                synchronized (object) {
                    if (this.spansList.size() < this.maxExportBatchSize) {
                        do {
                            try {
                                this.monitor.wait(this.scheduleDelayMillis);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        } while (this.spansList.isEmpty());
                    }
                    spansCopy = new ArrayList<ReadableSpan>(this.spansList);
                    this.spansList.clear();
                }
                this.exportBatches(spansCopy);
            }
        }

        private void shutdown() {
            this.forceFlush();
            this.executorService.shutdown();
            this.spanExporter.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forceFlush() {
            ArrayList<ReadableSpan> spansCopy;
            Object object = this.monitor;
            synchronized (object) {
                spansCopy = new ArrayList<ReadableSpan>(this.spansList);
                this.spansList.clear();
            }
            this.exportBatches(spansCopy);
        }

        private void exportBatches(ArrayList<ReadableSpan> spanList) {
            int i = 0;
            while (i < spanList.size()) {
                int lastIndexToTake = Math.min(i + this.maxExportBatchSize, spanList.size());
                this.onBatchExport(Worker.createSpanDataForExport(spanList, i, lastIndexToTake));
                i = lastIndexToTake;
            }
        }

        private static List<SpanData> createSpanDataForExport(List<ReadableSpan> spanList, int startIndex, int endIndex) {
            ArrayList<SpanData> spanDataBuffer = new ArrayList<SpanData>(endIndex - startIndex);
            for (int i = startIndex; i < endIndex; ++i) {
                spanDataBuffer.add(spanList.get(i).toSpanData());
                spanList.set(i, null);
            }
            return Collections.unmodifiableList(spanDataBuffer);
        }

        private void onBatchExport(final List<SpanData> spans) {
            Future<?> submission = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Worker.this.spanExporter.export(spans);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Exception thrown by the export.", t);
                    }
                }
            });
            try {
                submission.get(this.exporterTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.log(Level.WARNING, "Exception thrown by the export.", e);
            }
            catch (TimeoutException e) {
                logger.log(Level.WARNING, "Export timed out. Cancelling execution.", e);
                submission.cancel(true);
            }
        }

        static {
            Meter meter = OpenTelemetry.getMeter((String)"io.opentelemetry.sdk.trace");
            LongCounter droppedSpansCounter = meter.longCounterBuilder("droppedSpans").setUnit("1").setDescription("The number of spans dropped by the BatchSpanProcessor due to high throughput.").build();
            droppedSpans = droppedSpansCounter.bind(Labels.of((String)"spanProcessorType", (String)BatchSpanProcessor.class.getSimpleName()));
            logger = Logger.getLogger(Worker.class.getName());
        }
    }
}

