/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.sdk.trace.AutoValue_TimedEvent_RawTimedEvent;
import io.opentelemetry.sdk.trace.AutoValue_TimedEvent_RawTimedEventWithEvent;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.trace.Event;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class TimedEvent
implements SpanData.Event {
    private static final int DEFAULT_TOTAL_ATTRIBUTE_COUNT = 0;

    TimedEvent() {
    }

    static TimedEvent create(long epochNanos, String name, Attributes attributes, int totalAttributeCount) {
        return new AutoValue_TimedEvent_RawTimedEvent(name, attributes, epochNanos, totalAttributeCount);
    }

    static TimedEvent create(long epochNanos, Event event) {
        return new AutoValue_TimedEvent_RawTimedEventWithEvent(epochNanos, event, 0);
    }

    @AutoValue
    @Immutable
    static abstract class RawTimedEvent
    extends TimedEvent {
        RawTimedEvent() {
        }
    }

    @AutoValue
    @Immutable
    static abstract class RawTimedEventWithEvent
    extends TimedEvent {
        RawTimedEventWithEvent() {
        }

        abstract Event getEvent();

        public String getName() {
            return this.getEvent().getName();
        }

        public Attributes getAttributes() {
            return this.getEvent().getAttributes();
        }

        @Override
        public abstract int getTotalAttributeCount();
    }
}

