/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.sdk.trace.AutoValue_Samplers_Probability;
import io.opentelemetry.sdk.trace.AutoValue_Samplers_SamplingResultImpl;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.attributes.DoubleAttributeSetter;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Samplers {
    static final DoubleAttributeSetter SAMPLING_PROBABILITY = DoubleAttributeSetter.create((String)"sampling.probability");
    private static final Sampler.SamplingResult EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT = SamplingResultImpl.createWithoutAttributes(Sampler.Decision.RECORD_AND_SAMPLED);
    private static final Sampler.SamplingResult EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT = SamplingResultImpl.createWithoutAttributes(Sampler.Decision.NOT_RECORD);
    private static final Sampler.SamplingResult EMPTY_RECORDED_SAMPLING_RESULT = SamplingResultImpl.createWithoutAttributes(Sampler.Decision.RECORD);

    private Samplers() {
    }

    static boolean isRecording(Sampler.Decision decision) {
        return Sampler.Decision.RECORD.equals((Object)decision) || Sampler.Decision.RECORD_AND_SAMPLED.equals((Object)decision);
    }

    static boolean isSampled(Sampler.Decision decision) {
        return Sampler.Decision.RECORD_AND_SAMPLED.equals((Object)decision);
    }

    public static Sampler.SamplingResult samplingResult(Sampler.Decision decision, Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        return attributes.isEmpty() ? Samplers.emptySamplingResult(decision) : SamplingResultImpl.create(decision, attributes);
    }

    public static Sampler.SamplingResult emptySamplingResult(Sampler.Decision decision) {
        switch (decision) {
            case RECORD_AND_SAMPLED: {
                return EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
            }
            case RECORD: {
                return EMPTY_RECORDED_SAMPLING_RESULT;
            }
            case NOT_RECORD: {
                return EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
            }
        }
        throw new AssertionError((Object)"unrecognised samplingResult");
    }

    public static Sampler alwaysOn() {
        return AlwaysOnSampler.INSTANCE;
    }

    public static Sampler alwaysOff() {
        return AlwaysOffSampler.INSTANCE;
    }

    public static Sampler parentOrElse(Sampler delegateSampler) {
        return new ParentOrElse(delegateSampler);
    }

    public static Sampler probability(double probability) {
        return Probability.create(probability);
    }

    @Immutable
    @AutoValue
    static abstract class SamplingResultImpl
    implements Sampler.SamplingResult {
        SamplingResultImpl() {
        }

        static Sampler.SamplingResult createWithProbability(Sampler.Decision decision, double probability) {
            return new AutoValue_Samplers_SamplingResultImpl(decision, Attributes.of((String)SAMPLING_PROBABILITY.key(), (AttributeValue)AttributeValue.doubleAttributeValue((double)probability)));
        }

        static Sampler.SamplingResult createWithoutAttributes(Sampler.Decision decision) {
            return new AutoValue_Samplers_SamplingResultImpl(decision, Attributes.empty());
        }

        static Sampler.SamplingResult create(Sampler.Decision decision, Attributes attributes) {
            return new AutoValue_Samplers_SamplingResultImpl(decision, attributes);
        }

        @Override
        public abstract Sampler.Decision getDecision();

        @Override
        public abstract Attributes getAttributes();
    }

    @AutoValue
    @Immutable
    static abstract class Probability
    implements Sampler {
        Probability() {
        }

        static Probability create(double probability) {
            Preconditions.checkArgument((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (Object)"probability must be in range [0.0, 1.0]");
            long idUpperBound = probability == 0.0 ? Long.MIN_VALUE : (probability == 1.0 ? Long.MAX_VALUE : (long)(probability * 9.223372036854776E18));
            return new AutoValue_Samplers_Probability(probability, idUpperBound, SamplingResultImpl.createWithProbability(Sampler.Decision.RECORD_AND_SAMPLED, probability), SamplingResultImpl.createWithProbability(Sampler.Decision.NOT_RECORD, probability));
        }

        abstract double getProbability();

        abstract long getIdUpperBound();

        abstract Sampler.SamplingResult getPositiveSamplingResult();

        abstract Sampler.SamplingResult getNegativeSamplingResult();

        @Override
        public final Sampler.SamplingResult shouldSample(@Nullable SpanContext parentContext, TraceId traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, @Nullable List<Link> parentLinks) {
            if (parentContext != null && parentContext.getTraceFlags().isSampled()) {
                return EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
            }
            if (parentLinks != null) {
                for (Link parentLink : parentLinks) {
                    if (!parentLink.getContext().getTraceFlags().isSampled()) continue;
                    return EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
                }
            }
            return Math.abs(traceId.getTraceRandomPart()) < this.getIdUpperBound() ? this.getPositiveSamplingResult() : this.getNegativeSamplingResult();
        }

        @Override
        public final String getDescription() {
            return String.format("ProbabilitySampler{%.6f}", this.getProbability());
        }
    }

    @Immutable
    static class ParentOrElse
    implements Sampler {
        private final Sampler delegateSampler;

        ParentOrElse(Sampler delegateSampler) {
            this.delegateSampler = delegateSampler;
        }

        @Override
        public Sampler.SamplingResult shouldSample(@Nullable SpanContext parentContext, TraceId traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, List<Link> parentLinks) {
            if (parentContext != null) {
                if (parentContext.getTraceFlags().isSampled()) {
                    return EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
                }
                return EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
            }
            return this.delegateSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }

        @Override
        public String getDescription() {
            return String.format("ParentOrElse{%s}", this.delegateSampler.getDescription());
        }
    }

    @Immutable
    private static enum AlwaysOffSampler implements Sampler
    {
        INSTANCE;


        @Override
        public Sampler.SamplingResult shouldSample(@Nullable SpanContext parentContext, TraceId traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, List<Link> parentLinks) {
            return EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
        }

        @Override
        public String getDescription() {
            return "AlwaysOffSampler";
        }
    }

    @Immutable
    private static enum AlwaysOnSampler implements Sampler
    {
        INSTANCE;


        @Override
        public Sampler.SamplingResult shouldSample(@Nullable SpanContext parentContext, TraceId traceId, String name, Span.Kind spanKind, ReadableAttributes attributes, List<Link> parentLinks) {
            return EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
        }

        @Override
        public String getDescription() {
            return "AlwaysOnSampler";
        }
    }
}

