/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class EnvVarResource {
    private static final String OTEL_RESOURCE_ATTRIBUTES_ENV = "OTEL_RESOURCE_ATTRIBUTES";
    private static final String ATTRIBUTE_LIST_SPLITTER = ",";
    private static final String ATTRIBUTE_KEY_VALUE_SPLITTER = "=";
    private static final Resource ENV_VAR_RESOURCE = Resource.create(EnvVarResource.parseResourceAttributes(System.getenv("OTEL_RESOURCE_ATTRIBUTES")));

    private EnvVarResource() {
    }

    public static Resource getResource() {
        return ENV_VAR_RESOURCE;
    }

    @VisibleForTesting
    static Attributes parseResourceAttributes(@Nullable String rawEnvAttributes) {
        String[] rawAttributes;
        if (rawEnvAttributes == null) {
            return Attributes.empty();
        }
        Attributes.Builder attrBuilders = Attributes.newBuilder();
        for (String rawAttribute : rawAttributes = rawEnvAttributes.split(ATTRIBUTE_LIST_SPLITTER, -1)) {
            String[] keyValuePair = rawAttribute.split(ATTRIBUTE_KEY_VALUE_SPLITTER, -1);
            if (keyValuePair.length != 2) continue;
            attrBuilders.setAttribute(keyValuePair[0].trim(), keyValuePair[1].trim().replaceAll("^\"|\"$", ""));
        }
        return attrBuilders.build();
    }
}

