/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.common.Labels;
import io.opentelemetry.metrics.LongValueRecorder;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.Batchers;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.view.Aggregations;

final class LongValueRecorderSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements LongValueRecorder {
    private LongValueRecorderSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(Batchers.getDeltaAllLabels(descriptor, meterProviderSharedState, meterSharedState, Aggregations.minMaxSumCount())));
    }

    public void record(long value, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        boundInstrument.record(value);
        boundInstrument.unbind();
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(batcher);
    }

    static final class Builder
    extends AbstractInstrument.Builder<Builder>
    implements LongValueRecorder.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongValueRecorderSdk build() {
            return this.register(new LongValueRecorderSdk(this.getInstrumentDescriptor(InstrumentType.VALUE_RECORDER, InstrumentValueType.LONG), this.getMeterProviderSharedState(), this.getMeterSharedState()));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements LongValueRecorder.BoundLongValueRecorder {
        BoundInstrument(Batcher batcher) {
            super(batcher.getAggregator());
        }

        public void record(long value) {
            this.recordLong(value);
        }
    }
}

