/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.common.Labels;
import io.opentelemetry.metrics.DoubleCounter;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.Batchers;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.view.Aggregations;

final class DoubleCounterSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements DoubleCounter {
    private DoubleCounterSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(Batchers.getCumulativeAllLabels(descriptor, meterProviderSharedState, meterSharedState, Aggregations.sum())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(double increment, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        try {
            boundInstrument.add(increment);
        }
        finally {
            boundInstrument.unbind();
        }
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(batcher);
    }

    static final class Builder
    extends AbstractInstrument.Builder<Builder>
    implements DoubleCounter.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleCounterSdk build() {
            return this.register(new DoubleCounterSdk(this.getInstrumentDescriptor(InstrumentType.COUNTER, InstrumentValueType.DOUBLE), this.getMeterProviderSharedState(), this.getMeterSharedState()));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements DoubleCounter.BoundDoubleCounter {
        BoundInstrument(Batcher batcher) {
            super(batcher.getAggregator());
        }

        public void add(double increment) {
            if (increment < 0.0) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            this.recordDouble(increment);
        }
    }
}

