/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AutoValue_SpanWrapper;
import io.opentelemetry.sdk.trace.RecordEventsReadableSpan;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
abstract class SpanWrapper
implements SpanData {
    SpanWrapper() {
    }

    abstract RecordEventsReadableSpan delegate();

    abstract List<SpanData.Link> resolvedLinks();

    abstract List<SpanData.Event> resolvedEvents();

    abstract Map<String, AttributeValue> attributes();

    abstract int totalAttributeCount();

    abstract int totalRecordedEvents();

    abstract Status status();

    static SpanWrapper create(RecordEventsReadableSpan delegate, List<SpanData.Link> links, List<SpanData.Event> events, Map<String, AttributeValue> attributes, int totalAttributeCount, int totalRecordedEvents, Status status) {
        return new AutoValue_SpanWrapper(delegate, links, events, attributes, totalAttributeCount, totalRecordedEvents, status);
    }

    @Override
    public TraceId getTraceId() {
        return this.delegate().getContext().getTraceId();
    }

    @Override
    public SpanId getSpanId() {
        return this.delegate().getContext().getSpanId();
    }

    @Override
    public TraceFlags getTraceFlags() {
        return this.delegate().getSpanContext().getTraceFlags();
    }

    @Override
    public TraceState getTraceState() {
        return this.delegate().getSpanContext().getTraceState();
    }

    @Override
    public SpanId getParentSpanId() {
        return this.delegate().getParentSpanId();
    }

    @Override
    public Resource getResource() {
        return this.delegate().getResource();
    }

    @Override
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.delegate().getInstrumentationLibraryInfo();
    }

    @Override
    public String getName() {
        return this.delegate().getName();
    }

    @Override
    public Span.Kind getKind() {
        return this.delegate().getKind();
    }

    @Override
    public long getStartEpochNanos() {
        return this.delegate().getStartEpochNanos();
    }

    @Override
    public Map<String, AttributeValue> getAttributes() {
        return this.attributes();
    }

    @Override
    public List<SpanData.Event> getEvents() {
        return this.resolvedEvents();
    }

    @Override
    public List<SpanData.Link> getLinks() {
        return this.resolvedLinks();
    }

    @Override
    public Status getStatus() {
        return this.status();
    }

    @Override
    public long getEndEpochNanos() {
        return this.delegate().getEndEpochNanos();
    }

    @Override
    public boolean getHasRemoteParent() {
        return this.delegate().hasRemoteParent();
    }

    @Override
    public boolean getHasEnded() {
        return this.delegate().hasEnded();
    }

    @Override
    public int getTotalRecordedEvents() {
        return this.totalRecordedEvents();
    }

    @Override
    public int getTotalRecordedLinks() {
        return this.delegate().getTotalRecordedLinks();
    }

    @Override
    public int getTotalAttributeCount() {
        return this.totalAttributeCount();
    }
}

