/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.LongUpDownSumObserver;
import io.opentelemetry.sdk.metrics.AbstractAsynchronousInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batchers;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.view.Aggregations;

final class LongUpDownSumObserverSdk
extends AbstractAsynchronousInstrument<LongUpDownSumObserver.ResultLongUpDownSumObserver>
implements LongUpDownSumObserver {
    LongUpDownSumObserverSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(Batchers.getCumulativeAllLabels(descriptor, meterProviderSharedState, meterSharedState, Aggregations.lastValue())));
    }

    @Override
    LongUpDownSumObserver.ResultLongUpDownSumObserver newResult(ActiveBatcher activeBatcher) {
        return new ResultLongUpDownSumObserverSdk(activeBatcher);
    }

    private static final class ResultLongUpDownSumObserverSdk
    implements LongUpDownSumObserver.ResultLongUpDownSumObserver {
        private final ActiveBatcher activeBatcher;

        private ResultLongUpDownSumObserverSdk(ActiveBatcher activeBatcher) {
            this.activeBatcher = activeBatcher;
        }

        public void observe(long sum, String ... keyValueLabelPairs) {
            Aggregator aggregator = this.activeBatcher.getAggregator();
            aggregator.recordLong(sum);
            this.activeBatcher.batch(LabelSetSdk.create(keyValueLabelPairs), aggregator, false);
        }
    }

    static final class Builder
    extends AbstractAsynchronousInstrument.Builder<Builder>
    implements LongUpDownSumObserver.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongUpDownSumObserverSdk build() {
            return this.register(new LongUpDownSumObserverSdk(this.getInstrumentDescriptor(InstrumentType.UP_DOWN_SUM_OBSERVER, InstrumentValueType.LONG), this.getMeterProviderSharedState(), this.getMeterSharedState()));
        }
    }
}

