/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.AsynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

abstract class AbstractAsynchronousInstrument<T>
extends AbstractInstrument
implements AsynchronousInstrument<T> {
    @Nullable
    private volatile AsynchronousInstrument.Callback<T> metricUpdater = null;
    private final ReentrantLock collectLock = new ReentrantLock();

    AbstractAsynchronousInstrument(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, ActiveBatcher activeBatcher) {
        super(descriptor, meterProviderSharedState, meterSharedState, activeBatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<MetricData> collectAll() {
        AsynchronousInstrument.Callback<T> currentMetricUpdater = this.metricUpdater;
        if (currentMetricUpdater == null) {
            return Collections.emptyList();
        }
        this.collectLock.lock();
        try {
            ActiveBatcher activeBatcher = this.getActiveBatcher();
            currentMetricUpdater.update(this.newResult(activeBatcher));
            List<MetricData> list = activeBatcher.completeCollectionCycle();
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    public void setCallback(AsynchronousInstrument.Callback<T> callback) {
        this.metricUpdater = Objects.requireNonNull(callback, "callback");
    }

    abstract T newResult(ActiveBatcher var1);

    static abstract class Builder<B extends AbstractInstrument.Builder<?>>
    extends AbstractInstrument.Builder<B> {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }
    }
}

