/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.common;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger counter = new AtomicInteger();

    public DaemonThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = MoreExecutors.platformThreadFactory().newThread(runnable);
        try {
            t.setDaemon(true);
            t.setName(this.namePrefix + "_" + this.counter.incrementAndGet());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return t;
    }
}

