/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.NoopAggregator;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class Batchers {
    static Batcher getNoop() {
        return Noop.INSTANCE;
    }

    static Batcher getCumulativeAllLabels(MetricData.Descriptor descriptor, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, AggregatorFactory aggregatorFactory, Clock clock) {
        return new AllLabels(descriptor, resource, instrumentationLibraryInfo, aggregatorFactory, clock, false);
    }

    private Batchers() {
    }

    private static final class AllLabels
    implements Batcher {
        private final MetricData.Descriptor descriptor;
        private final Resource resource;
        private final InstrumentationLibraryInfo instrumentationLibraryInfo;
        private final Clock clock;
        private final AggregatorFactory aggregatorFactory;
        private Map<Map<String, String>, Aggregator> aggregatorMap;
        private long startEpochNanos;
        private final boolean delta;

        private AllLabels(MetricData.Descriptor descriptor, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, AggregatorFactory aggregatorFactory, Clock clock, boolean delta) {
            this.descriptor = descriptor;
            this.resource = resource;
            this.instrumentationLibraryInfo = instrumentationLibraryInfo;
            this.clock = clock;
            this.aggregatorFactory = aggregatorFactory;
            this.delta = delta;
            this.aggregatorMap = new HashMap<Map<String, String>, Aggregator>();
            this.startEpochNanos = clock.now();
        }

        @Override
        public final Aggregator getAggregator() {
            return this.aggregatorFactory.getAggregator();
        }

        @Override
        public final void batch(LabelSetSdk labelSet, Aggregator aggregator, boolean unmappedAggregator) {
            Map<String, String> labels = labelSet.getLabels();
            Aggregator currentAggregator = this.aggregatorMap.get(labels);
            if (currentAggregator == null) {
                if (unmappedAggregator) {
                    this.aggregatorMap.put(labels, aggregator);
                    return;
                }
                currentAggregator = this.aggregatorFactory.getAggregator();
                this.aggregatorMap.put(labels, currentAggregator);
            }
            aggregator.mergeToAndReset(currentAggregator);
        }

        @Override
        public final List<MetricData> completeCollectionCycle() {
            ArrayList<MetricData.Point> points = new ArrayList<MetricData.Point>(this.aggregatorMap.size());
            long epochNanos = this.clock.now();
            for (Map.Entry<Map<String, String>, Aggregator> entry : this.aggregatorMap.entrySet()) {
                points.add(entry.getValue().toPoint(this.startEpochNanos, epochNanos, entry.getKey()));
            }
            if (this.delta) {
                this.startEpochNanos = epochNanos;
                this.aggregatorMap = new HashMap<Map<String, String>, Aggregator>();
            }
            return Collections.singletonList(MetricData.create(this.descriptor, this.resource, this.instrumentationLibraryInfo, points));
        }
    }

    private static final class Noop
    implements Batcher {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public Aggregator getAggregator() {
            return NoopAggregator.getFactory().getAggregator();
        }

        @Override
        public void batch(LabelSetSdk labelSet, Aggregator aggregator, boolean mappedAggregator) {
        }

        @Override
        public List<MetricData> completeCollectionCycle() {
            return Collections.emptyList();
        }
    }
}

