/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.common.AttributeValue;
import java.util.LinkedHashMap;
import java.util.Map;

final class AttributesWithCapacity
extends LinkedHashMap<String, AttributeValue> {
    private final long capacity;
    private int totalRecordedAttributes = 0;
    private static final long serialVersionUID = 42L;

    AttributesWithCapacity(long capacity) {
        super((int)capacity + 1, 1.0f, true);
        this.capacity = capacity;
    }

    void putAttribute(String key, AttributeValue value) {
        ++this.totalRecordedAttributes;
        this.put(key, value);
    }

    void putAllAttributes(Map<String, AttributeValue> m) {
        for (Map.Entry<String, AttributeValue> entry : m.entrySet()) {
            this.putAttribute(entry.getKey(), entry.getValue());
        }
    }

    int getNumberOfDroppedAttributes() {
        return this.totalRecordedAttributes - this.size();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, AttributeValue> eldest) {
        return (long)this.size() > this.capacity;
    }
}

