/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.Meter;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.BatchRecorderSdk;
import io.opentelemetry.sdk.metrics.DoubleCounterSdk;
import io.opentelemetry.sdk.metrics.DoubleMeasureSdk;
import io.opentelemetry.sdk.metrics.DoubleObserverSdk;
import io.opentelemetry.sdk.metrics.InstrumentRegistry;
import io.opentelemetry.sdk.metrics.LongCounterSdk;
import io.opentelemetry.sdk.metrics.LongMeasureSdk;
import io.opentelemetry.sdk.metrics.LongObserverSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.ArrayList;
import java.util.Collection;

final class MeterSdk
implements Meter {
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;

    MeterSdk(MeterProviderSharedState meterProviderSharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = MeterSharedState.create(instrumentationLibraryInfo);
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.meterSharedState.getInstrumentationLibraryInfo();
    }

    public DoubleCounterSdk.Builder doubleCounterBuilder(String name) {
        return new DoubleCounterSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public LongCounterSdk.Builder longCounterBuilder(String name) {
        return new LongCounterSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public DoubleMeasureSdk.Builder doubleMeasureBuilder(String name) {
        return new DoubleMeasureSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public LongMeasureSdk.Builder longMeasureBuilder(String name) {
        return new LongMeasureSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public DoubleObserverSdk.Builder doubleObserverBuilder(String name) {
        return new DoubleObserverSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public LongObserverSdk.Builder longObserverBuilder(String name) {
        return new LongObserverSdk.Builder(name, this.meterProviderSharedState, this.meterSharedState);
    }

    public BatchRecorderSdk newBatchRecorder(String ... keyValuePairs) {
        return new BatchRecorderSdk(keyValuePairs);
    }

    Collection<MetricData> collectAll() {
        InstrumentRegistry instrumentRegistry = this.meterSharedState.getInstrumentRegistry();
        Collection<AbstractInstrument> instruments = instrumentRegistry.getInstruments();
        ArrayList<MetricData> result = new ArrayList<MetricData>(instruments.size());
        for (AbstractInstrument instrument : instruments) {
            result.addAll(instrument.collectAll());
        }
        return result;
    }
}

