/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.LongMeasure;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractMeasure;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongMeasureSdk
extends AbstractMeasure<BoundInstrument>
implements LongMeasure {
    private LongMeasureSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, boolean absolute) {
        super(descriptor, InstrumentValueType.LONG, meterProviderSharedState, meterSharedState, absolute);
    }

    public void record(long value, String ... labelKeyValuePairs) {
        this.record(value, LabelSetSdk.create(labelKeyValuePairs));
    }

    void record(long value, LabelSetSdk labelSet) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labelSet);
        boundInstrument.record(value);
        boundInstrument.unbind();
    }

    public BoundInstrument bind(String ... labelKeyValuePairs) {
        return (BoundInstrument)this.bind(LabelSetSdk.create(labelKeyValuePairs));
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(this.isAbsolute(), batcher);
    }

    static final class Builder
    extends AbstractMeasure.Builder<Builder>
    implements LongMeasure.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongMeasureSdk build() {
            return this.register(new LongMeasureSdk(this.getInstrumentDescriptor(), this.getMeterProviderSharedState(), this.getMeterSharedState(), this.isAbsolute()));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements LongMeasure.BoundLongMeasure {
        private final boolean absolute;

        BoundInstrument(boolean absolute, Batcher batcher) {
            super(batcher.getAggregator());
            this.absolute = absolute;
        }

        public void record(long value) {
            if (this.absolute && value < 0L) {
                throw new IllegalArgumentException("absolute measure can only record positive values");
            }
            this.recordLong(value);
        }
    }
}

