/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import com.google.auto.value.AutoValue;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.metrics.AutoValue_LabelSetSdk;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class LabelSetSdk {
    private static final LabelSetSdk EMPTY = new AutoValue_LabelSetSdk(Collections.emptyMap());

    LabelSetSdk() {
    }

    static LabelSetSdk create(Map<String, String> labels) {
        if (labels == null || labels.isEmpty()) {
            return EMPTY;
        }
        return new AutoValue_LabelSetSdk(Collections.unmodifiableMap(labels));
    }

    static LabelSetSdk create(String ... keyValuePairs) {
        if (keyValuePairs.length == 0) {
            return EMPTY;
        }
        Utils.validateLabelPairs((String[])keyValuePairs);
        HashMap<String, String> data = new HashMap<String, String>(keyValuePairs.length / 2);
        for (int i = 0; i < keyValuePairs.length; ++i) {
            String key = keyValuePairs[i];
            data.put(key, keyValuePairs[++i]);
        }
        return new AutoValue_LabelSetSdk(Collections.unmodifiableMap(data));
    }

    abstract Map<String, String> getLabels();
}

