/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.Observer;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.view.Aggregations;

abstract class AbstractObserver
extends AbstractInstrument {
    private final boolean monotonic;
    private final InstrumentValueType instrumentValueType;

    AbstractObserver(InstrumentDescriptor descriptor, InstrumentValueType instrumentValueType, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, boolean monotonic) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(new ActiveBatcher(AbstractObserver.getDefaultBatcher(descriptor, AbstractObserver.getInstrumentType(monotonic), instrumentValueType, meterProviderSharedState, meterSharedState, Aggregations.lastValue()))));
        this.monotonic = monotonic;
        this.instrumentValueType = instrumentValueType;
    }

    final boolean isMonotonic() {
        return this.monotonic;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractObserver)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractObserver that = (AbstractObserver)o;
        return this.monotonic == that.monotonic && this.instrumentValueType == that.instrumentValueType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.monotonic ? 1 : 0);
        result = 31 * result + this.instrumentValueType.hashCode();
        return result;
    }

    private static InstrumentType getInstrumentType(boolean monotonic) {
        return monotonic ? InstrumentType.OBSERVER_MONOTONIC : InstrumentType.OBSERVER_NON_MONOTONIC;
    }

    static abstract class Builder<B extends Builder<B>>
    extends AbstractInstrument.Builder<B>
    implements Observer.Builder {
        private boolean monotonic = false;

        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        public final B setMonotonic(boolean monotonic) {
            this.monotonic = monotonic;
            return (B)((Builder)this.getThis());
        }

        final boolean isMonotonic() {
            return this.monotonic;
        }
    }
}

