/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.sdk.trace.AutoValue_Samplers_Probability;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Samplers {
    private static final Sampler ALWAYS_ON = new AlwaysOnSampler();
    private static final Sampler ALWAYS_OFF = new AlwaysOffSampler();
    private static final Sampler.Decision ALWAYS_ON_DECISION = new SimpleDecision(true);
    private static final Sampler.Decision ALWAYS_OFF_DECISION = new SimpleDecision(false);

    private Samplers() {
    }

    public static Sampler alwaysOn() {
        return ALWAYS_ON;
    }

    public static Sampler alwaysOff() {
        return ALWAYS_OFF;
    }

    public static Sampler probability(double probability) {
        return Probability.create(probability);
    }

    @Immutable
    private static final class SimpleDecision
    implements Sampler.Decision {
        private final boolean decision;

        SimpleDecision(boolean decision) {
            this.decision = decision;
        }

        @Override
        public boolean isSampled() {
            return this.decision;
        }

        @Override
        public Map<String, AttributeValue> attributes() {
            return Collections.emptyMap();
        }
    }

    @AutoValue
    @Immutable
    static abstract class Probability
    implements Sampler {
        Probability() {
        }

        static Probability create(double probability) {
            Preconditions.checkArgument((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (Object)"probability must be in range [0.0, 1.0]");
            long idUpperBound = probability == 0.0 ? Long.MIN_VALUE : (probability == 1.0 ? Long.MAX_VALUE : (long)(probability * 9.223372036854776E18));
            return new AutoValue_Samplers_Probability(probability, idUpperBound);
        }

        abstract double getProbability();

        abstract long getIdUpperBound();

        @Override
        public final Sampler.Decision shouldSample(@Nullable SpanContext parentContext, TraceId traceId, SpanId spanId, String name, Span.Kind spanKind, Map<String, AttributeValue> attributes, @Nullable List<Link> parentLinks) {
            if (parentContext != null && parentContext.getTraceFlags().isSampled()) {
                return ALWAYS_ON_DECISION;
            }
            if (parentLinks != null) {
                for (Link parentLink : parentLinks) {
                    if (!parentLink.getContext().getTraceFlags().isSampled()) continue;
                    return ALWAYS_ON_DECISION;
                }
            }
            return Math.abs(traceId.getLowerLong()) < this.getIdUpperBound() ? ALWAYS_ON_DECISION : ALWAYS_OFF_DECISION;
        }

        @Override
        public final String getDescription() {
            return String.format("ProbabilitySampler{%.6f}", this.getProbability());
        }
    }

    @Immutable
    private static final class AlwaysOffSampler
    implements Sampler {
        AlwaysOffSampler() {
        }

        @Override
        public Sampler.Decision shouldSample(@Nullable SpanContext parentContext, TraceId traceId, SpanId spanId, String name, Span.Kind spanKind, Map<String, AttributeValue> attributes, List<Link> parentLinks) {
            return ALWAYS_OFF_DECISION;
        }

        @Override
        public String getDescription() {
            return this.toString();
        }

        public String toString() {
            return "AlwaysOffSampler";
        }
    }

    @Immutable
    private static final class AlwaysOnSampler
    implements Sampler {
        AlwaysOnSampler() {
        }

        @Override
        public Sampler.Decision shouldSample(@Nullable SpanContext parentContext, TraceId traceId, SpanId spanId, String name, Span.Kind spanKind, Map<String, AttributeValue> attributes, List<Link> parentLinks) {
            return ALWAYS_ON_DECISION;
        }

        @Override
        public String getDescription() {
            return this.toString();
        }

        public String toString() {
            return "AlwaysOnSampler";
        }
    }
}

