/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class EnvVarResource {
    private static final String OTEL_RESOURCE_ATTRIBUTES_ENV = "OTEL_RESOURCE_ATTRIBUTES";
    private static final String ATTRIBUTE_LIST_SPLITTER = ",";
    private static final String ATTRIBUTE_KEY_VALUE_SPLITTER = "=";
    private static final Resource ENV_VAR_RESOURCE = Resource.create(EnvVarResource.parseResourceAttributes(System.getenv("OTEL_RESOURCE_ATTRIBUTES")));

    private EnvVarResource() {
    }

    public static Resource getResource() {
        return ENV_VAR_RESOURCE;
    }

    private static Map<String, AttributeValue> parseResourceAttributes(@Nullable String rawEnvAttributes) {
        String[] rawAttributes;
        if (rawEnvAttributes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        for (String rawAttribute : rawAttributes = rawEnvAttributes.split(ATTRIBUTE_LIST_SPLITTER, -1)) {
            String[] keyValuePair = rawAttribute.split(ATTRIBUTE_KEY_VALUE_SPLITTER, -1);
            if (keyValuePair.length != 2) continue;
            String key = keyValuePair[0].trim();
            AttributeValue value = AttributeValue.stringAttributeValue((String)keyValuePair[1].trim().replaceAll("^\"|\"$", ""));
            attributes.put(key, value);
        }
        return Collections.unmodifiableMap(attributes);
    }
}

