/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.DoubleMeasure;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractMeasure;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleMeasureSdk
extends AbstractMeasure<BoundInstrument>
implements DoubleMeasure {
    private DoubleMeasureSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, boolean absolute) {
        super(descriptor, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState, absolute);
    }

    public void record(double delta, String ... labelKeyValuePairs) {
        this.record(delta, LabelSetSdk.create(labelKeyValuePairs));
    }

    void record(double value, LabelSetSdk labelSet) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bindInternal(labelSet);
        boundInstrument.record(value);
        boundInstrument.unbind();
    }

    public BoundInstrument bind(String ... labelKeyValuePairs) {
        return (BoundInstrument)this.bindInternal(LabelSetSdk.create(labelKeyValuePairs));
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(this.isAbsolute(), batcher);
    }

    static final class Builder
    extends AbstractMeasure.Builder<Builder>
    implements DoubleMeasure.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleMeasureSdk build() {
            return this.register(new DoubleMeasureSdk(this.getInstrumentDescriptor(), this.getMeterProviderSharedState(), this.getMeterSharedState(), this.isAbsolute()));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements DoubleMeasure.BoundDoubleMeasure {
        private final boolean absolute;

        BoundInstrument(boolean absolute, Batcher batcher) {
            super(batcher.getAggregator());
            this.absolute = absolute;
        }

        public void record(double value) {
            if (this.absolute && value < 0.0) {
                throw new IllegalArgumentException("absolute measure can only record positive values");
            }
            this.recordDouble(value);
        }
    }
}

