/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.DoubleCounter;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractCounter;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleCounterSdk
extends AbstractCounter<BoundInstrument>
implements DoubleCounter {
    private DoubleCounterSdk(InstrumentDescriptor descriptor, boolean monotonic, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
        super(descriptor, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState, monotonic);
    }

    public void add(double delta, String ... labelKeyValuePairs) {
        this.add(delta, LabelSetSdk.create(labelKeyValuePairs));
    }

    void add(double delta, LabelSetSdk labelSet) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bindInternal(labelSet);
        boundInstrument.add(delta);
        boundInstrument.unbind();
    }

    public BoundInstrument bind(String ... labelKeyValuePairs) {
        return (BoundInstrument)this.bindInternal(LabelSetSdk.create(labelKeyValuePairs));
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(this.isMonotonic(), batcher);
    }

    static final class Builder
    extends AbstractCounter.Builder<Builder>
    implements DoubleCounter.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleCounterSdk build() {
            return this.register(new DoubleCounterSdk(this.getInstrumentDescriptor(), this.isMonotonic(), this.getMeterProviderSharedState(), this.getMeterSharedState()));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements DoubleCounter.BoundDoubleCounter {
        private final boolean monotonic;

        BoundInstrument(boolean monotonic, Batcher batcher) {
            super(batcher.getAggregator());
            this.monotonic = monotonic;
        }

        public void add(double delta) {
            if (this.monotonic && delta < 0.0) {
                throw new IllegalArgumentException("monotonic counters can only increase");
            }
            this.recordDouble(delta);
        }
    }
}

